/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import slimeknights.mantle.client.TooltipKey;

public class SafeClientAccess {
    public static TooltipKey getTooltipKey() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return ClientOnly.getPressedKey();
        }
        return TooltipKey.UNKNOWN;
    }

    @Nullable
    public static Player getPlayer() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return ClientOnly.getClientPlayer();
        }
        return null;
    }

    @Nullable
    public static Level getLevel() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return ClientOnly.getClientLevel();
        }
        return null;
    }

    @Nullable
    public static RegistryAccess getRegistryAccess() {
        Level level = SafeClientAccess.getLevel();
        if (level != null) {
            return level.m_9598_();
        }
        return null;
    }

    public static boolean isAdvancedTooltip() {
        return FMLEnvironment.dist == Dist.CLIENT && ClientOnly.isAdvancedTooltip();
    }

    private static class ClientOnly {
        private ClientOnly() {
        }

        public static TooltipKey getPressedKey() {
            if (Screen.m_96638_()) {
                return TooltipKey.SHIFT;
            }
            if (Screen.m_96637_()) {
                return TooltipKey.CONTROL;
            }
            if (Screen.m_96639_()) {
                return TooltipKey.ALT;
            }
            return TooltipKey.NORMAL;
        }

        @Nullable
        public static Player getClientPlayer() {
            return Minecraft.m_91087_().f_91074_;
        }

        @Nullable
        public static Level getClientLevel() {
            return Minecraft.m_91087_().f_91073_;
        }

        public static boolean isAdvancedTooltip() {
            return Minecraft.m_91087_().f_91066_.f_92125_;
        }
    }
}

