/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.mining;

import java.util.Collection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.mining.IsEffectiveToolHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public interface MiningSpeedToolHook {
    public float modifyDestroySpeed(IToolStackView var1, BlockState var2, float var3);

    public static float getDestroySpeed(ItemStack tool, BlockState state) {
        if (!tool.m_41782_()) {
            return 1.0f;
        }
        return MiningSpeedToolHook.getDestroySpeed(ToolStack.from(tool), state);
    }

    public static float getDestroySpeed(IToolStackView tool, BlockState state) {
        if (tool.isBroken()) {
            return 0.3f;
        }
        float speed = IsEffectiveToolHook.isEffective(tool, state) ? tool.getStats().get(ToolStats.MINING_SPEED).floatValue() : 1.0f;
        return Math.max(1.0f, tool.getHook(ToolHooks.MINING_SPEED).modifyDestroySpeed(tool, state, speed));
    }

    public record ComposeMerger(Collection<MiningSpeedToolHook> hooks) implements MiningSpeedToolHook
    {
        @Override
        public float modifyDestroySpeed(IToolStackView tool, BlockState state, float speed) {
            for (MiningSpeedToolHook hook : this.hooks) {
                speed = hook.modifyDestroySpeed(tool, state, speed);
            }
            return speed;
        }
    }
}

