/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.vampiresneedumbrellas.items;

import com.focamacho.vampiresneedumbrellas.config.ConfigHolder;
import com.focamacho.vampiresneedumbrellas.handlers.CuriosHandler;
import com.focamacho.vampiresneedumbrellas.handlers.VampirismHandler;
import com.focamacho.vampiresneedumbrellas.utils.Utils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemUmbrella
extends Item {
    private static final UUID SPEED_ATTRIBUTE = UUID.fromString("278caaa5-8912-490c-acb1-d3c10bac2150");
    private final Supplier<Integer> durabilitySupplier;
    private final Supplier<Double> speedSupplier;
    private final Item repairItem;

    public ItemUmbrella(Item.Properties builder, Supplier<Integer> durabilitySupplier, Supplier<Double> speedSupplier, Item repairItem) {
        super(builder);
        this.durabilitySupplier = durabilitySupplier;
        this.speedSupplier = speedSupplier;
        this.repairItem = repairItem;
    }

    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (Utils.isVampirismLoaded) {
            VampirismHandler.applyEffect(stack, worldIn, entityIn, this.isDamageable(stack));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap attributes = HashMultimap.create();
        if (this.speedSupplier.get() != 0.0 && (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND)) {
            attributes.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(SPEED_ATTRIBUTE, "Umbrella Speed Modifier", this.speedSupplier.get().doubleValue(), AttributeModifier.Operation.MULTIPLY_BASE));
        }
        return attributes;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return Utils.isCuriosLoaded ? CuriosHandler.initCapabilities(stack, nbt, SPEED_ATTRIBUTE, this.speedSupplier.get()) : super.initCapabilities(stack, nbt);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.durabilitySupplier.get();
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return ConfigHolder.umbrellaAnvil;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return this.durabilitySupplier.get() != -1;
    }

    @ParametersAreNonnullByDefault
    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return ConfigHolder.umbrellaRepair && repair.m_41720_().equals(this.repairItem);
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f - (float)stack.m_41773_() * 13.0f / (float)this.getMaxDamage(stack));
    }

    @ParametersAreNonnullByDefault
    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, ((float)this.getMaxDamage(stack) - (float)stack.m_41773_()) / (float)this.getMaxDamage(stack));
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }
}

