/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public class RoundRobinList<E>
extends ArrayList<E> {
    private int lastIndex;

    public RoundRobinList() {
    }

    public RoundRobinList(int initialCapacity) {
        super(initialCapacity);
    }

    public RoundRobinList(@Nonnull Collection<? extends E> c) {
        super(c);
    }

    public E next() {
        Object e = this.get(this.lastIndex);
        this.skip(1);
        return e;
    }

    public E prev() {
        this.backward(1);
        return this.get(this.lastIndex);
    }

    public void skip(int steps) {
        this.setPos(this.lastIndex + steps);
    }

    public void backward(int steps) {
        int s;
        for (s = this.lastIndex - steps; s < 0; s += this.size()) {
        }
        this.setPos(s);
    }

    public int getPos() {
        return this.lastIndex;
    }

    public void setPos(int i) {
        this.lastIndex = Math.abs(i) % this.size();
    }

    public static <T> RoundRobinList<T> of(T ... arr) {
        return new RoundRobinList<T>(List.of(arr));
    }

    public static <T> RoundRobinList<T> copyOf(Collection<? extends T> coll) {
        return new RoundRobinList<T>(coll);
    }
}

