/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.proxy;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Either;
import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.forge.ContainerAPI;
import org.zeith.hammerlib.api.inv.IScreenContainer;
import org.zeith.hammerlib.api.items.tooltip.TooltipColoredLine;
import org.zeith.hammerlib.api.items.tooltip.TooltipMulti;
import org.zeith.hammerlib.api.lighting.ColoredLight;
import org.zeith.hammerlib.api.lighting.HandleLightOverrideEvent;
import org.zeith.hammerlib.api.lighting.impl.IGlowingEntity;
import org.zeith.hammerlib.api.proxy.IClientProxy;
import org.zeith.hammerlib.client.flowgui.reader.FlowguiReader;
import org.zeith.hammerlib.client.flowgui.reader.FlowguiRegistry;
import org.zeith.hammerlib.client.flowgui.reader.XmlFlowgui;
import org.zeith.hammerlib.client.model.SimpleModelGenerator;
import org.zeith.hammerlib.client.render.tile.IBESR;
import org.zeith.hammerlib.client.render.tile.TESRBase;
import org.zeith.hammerlib.client.utils.TexturePixelGetter;
import org.zeith.hammerlib.core.adapter.ConfigAdapter;
import org.zeith.hammerlib.core.adapter.FingerprintCheckAdapter;
import org.zeith.hammerlib.core.items.tooltip.ClientTooltipColoredLine;
import org.zeith.hammerlib.core.items.tooltip.ClientTooltipMulti;
import org.zeith.hammerlib.core.scans.ScanRequireStencil;
import org.zeith.hammerlib.core.scans.base.DataScanner;
import org.zeith.hammerlib.core.scans.base.IAnnotationScanListener;
import org.zeith.hammerlib.event.client.ClientLoadedInEvent;
import org.zeith.hammerlib.mixins.client.ParticleEngineAccessor;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.packets.PacketPlayerReady;
import org.zeith.hammerlib.net.packets.PingServerPacket;
import org.zeith.hammerlib.proxy.HLCommonProxy;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.mcf.LogicalSidePredictor;
import org.zeith.hammerlib.util.mcf.RunnableReloader;

public class HLClientProxy
extends HLCommonProxy
implements IClientProxy {
    protected List<HLCommonProxy.QueuedTask> clientTickTasks = new ArrayList<HLCommonProxy.QueuedTask>();
    public static final KeyMapping RENDER_GUI_ITEM = new KeyMapping("key.hammerlib.render_item", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, InputConstants.f_84822_.m_84873_(), "key.categories.ui");
    public static Map<ParticleRenderType, Queue<Particle>> PARTICLE_MAP;
    int pingTimer;
    boolean renderedWorld = false;

    public HLClientProxy() {
        MinecraftForge.EVENT_BUS.addListener(this::clientTick);
    }

    @Override
    public void queueTask(Level level, int delay, Runnable task) {
        super.queueTask(level, delay, task);
        if (level.f_46443_) {
            this.clientTickTasks.add(new HLCommonProxy.QueuedTask(delay, task));
        }
    }

    @Override
    public void appendScans(DataScanner data) {
        data.add(IAnnotationScanListener.forAnnotation(FlowguiReader.class, ElementType.TYPE, FlowguiRegistry::handleReader));
        data.add(IAnnotationScanListener.forAnnotation(XmlFlowgui.class, ElementType.TYPE, FlowguiRegistry::handleXml));
        data.add(ScanRequireStencil.create());
    }

    @Override
    public void construct(IEventBus modBus) {
        modBus.addListener(this::registerKeybinds);
        modBus.addListener(this::modelBake);
        modBus.addListener(this::registerReloadListeners);
        modBus.addListener(this::registerClientTooltips);
        modBus.addListener(this::loadComplete);
        modBus.addListener(TexturePixelGetter::reloadTexture);
        modBus.addListener(this::clientSetup);
        SimpleModelGenerator.setup();
    }

    private void loadComplete(FMLLoadCompleteEvent e) {
        FingerprintCheckAdapter.loadComplete();
    }

    private void alterTooltip(RenderTooltipEvent.GatherComponents e) {
        int[] colors = TexturePixelGetter.getAllColors(e.getItemStack());
        e.getTooltipElements().add(Either.right((Object)new TooltipColoredLine(colors)));
    }

    private void registerReloadListeners(RegisterClientReloadListenersEvent e) {
        e.registerReloadListener((PreparableReloadListener)RunnableReloader.of(FlowguiRegistry::reload));
    }

    private void registerClientTooltips(RegisterClientTooltipComponentFactoriesEvent e) {
        e.register(TooltipMulti.class, ClientTooltipMulti::new);
        e.register(TooltipColoredLine.class, ClientTooltipColoredLine::new);
    }

    private void registerKeybinds(RegisterKeyMappingsEvent e) {
        e.register(RENDER_GUI_ITEM);
    }

    private void modelBake(ModelEvent.BakingCompleted e) {
    }

    private void clientSetup(FMLClientSetupEvent e) {
        MenuScreens.m_96206_(ContainerAPI.TILE_CONTAINER, (ctr, inv, txt) -> Cast.optionally(ctr, IScreenContainer.class).map(c -> c.openScreen(inv, txt)).orElse(null));
        PARTICLE_MAP = ((ParticleEngineAccessor)Minecraft.m_91087_().f_91061_).getParticles();
        e.enqueueWork(ScanRequireStencil.requestStencil());
    }

    public static Stream<Particle> streamParticles() {
        return PARTICLE_MAP.values().stream().flatMap(Collection::stream);
    }

    @Override
    public Stream<ColoredLight> getGlowingParticles(float partialTicks) {
        return HLClientProxy.streamParticles().map(particle -> {
            ColoredLight l = null;
            IGlowingEntity ent = Cast.cast(Float.valueOf(partialTicks), IGlowingEntity.class);
            if (ent != null) {
                l = ent.produceColoredLight(partialTicks);
            }
            HandleLightOverrideEvent<Particle> evt = new HandleLightOverrideEvent<Particle>((Particle)particle, partialTicks, l);
            HammerLib.postEvent(evt);
            return evt.getNewLight();
        }).filter(Objects::nonNull);
    }

    @Override
    public Consumer<FMLClientSetupEvent> addTESR(BlockEntityType<?> type, Class<?> anyTesr) {
        return e -> {
            ResourceLocation name = ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)type);
            if (name == null) {
                HammerLib.LOG.info("Skipping TESR for tile " + type + " as it is not registered.");
                return;
            }
            HammerLib.LOG.info("Registering TESR for tile " + name);
            Function<BlockEntityRendererProvider.Context, BlockEntityRenderer> theTesr = null;
            if (IBESR.class.isAssignableFrom(anyTesr)) {
                try {
                    Constructor ctor = anyTesr.getDeclaredConstructor(new Class[0]);
                    ctor.setAccessible(true);
                    TESRBase base = new TESRBase((IBESR)ctor.newInstance(new Object[0]));
                    theTesr = ctx -> base;
                }
                catch (ReflectiveOperationException err) {
                    throw new ReportedException(new CrashReport("Unable to create IBESR(no-args) for BlockEntityType " + name, (Throwable)err));
                }
            }
            if (theTesr == null) {
                for (Constructor<?> ctr : anyTesr.getDeclaredConstructors()) {
                    try {
                        if (ctr.getParameterCount() == 0) {
                            BlockEntityRenderer r = (BlockEntityRenderer)ctr.newInstance(new Object[0]);
                            theTesr = c -> r;
                            continue;
                        }
                        if (ctr.getParameterCount() != 1 || ctr.getParameterTypes()[0] != BlockEntityRendererProvider.Context.class) continue;
                        theTesr = ctx -> {
                            try {
                                return (BlockEntityRenderer)Cast.cast(ctr.newInstance(ctx));
                            }
                            catch (ReflectiveOperationException err) {
                                throw new ReportedException(new CrashReport("Unable to create BlockEntityRenderer(no-args) for BlockEntityType " + name, (Throwable)err));
                            }
                        };
                    }
                    catch (ReflectiveOperationException err) {
                        throw new ReportedException(new CrashReport("Unable to create BlockEntityRenderer(no-args) for BlockEntityType " + name, (Throwable)err));
                    }
                }
            }
            if (theTesr == null) {
                throw new RuntimeException("Unable to find a valid constructor for " + name + "'s TESR " + anyTesr);
            }
            Function<BlockEntityRendererProvider.Context, BlockEntityRenderer> finalTheTesr = theTesr;
            BlockEntityRenderers.m_173590_((BlockEntityType)type, ctx -> (BlockEntityRenderer)Cast.cast(finalTheTesr.apply(ctx)));
        };
    }

    @Override
    public Consumer<RegisterParticleProvidersEvent> addParticleTypeProvider(ParticleType<?> type, Class<?> providerCls) {
        return e -> {
            Constructor<?>[] ctors;
            ResourceLocation name = BuiltInRegistries.f_257034_.m_7981_((Object)type);
            if (name == null) {
                HammerLib.LOG.info("Skipping Particles for particle type " + type + " as it is not registered.");
                return;
            }
            HammerLib.LOG.info("Registering ParticleProvider for particle type " + name);
            if (ParticleProvider.Sprite.class.isAssignableFrom(providerCls)) {
                try {
                    Constructor<ParticleProvider.Sprite> spc = providerCls.asSubclass(ParticleProvider.Sprite.class).getDeclaredConstructor(new Class[0]);
                    spc.setAccessible(true);
                    e.registerSprite(type, spc.newInstance(new Object[0]));
                    return;
                }
                catch (ReflectiveOperationException ex) {
                    throw new ReportedException(new CrashReport("Unable to create ParticleProvider.Sprite(no-args) for ParticleType " + name, (Throwable)ex));
                }
            }
            if (ParticleEngine.SpriteParticleRegistration.class.isAssignableFrom(providerCls)) {
                try {
                    Constructor<ParticleEngine.SpriteParticleRegistration> spc = providerCls.asSubclass(ParticleEngine.SpriteParticleRegistration.class).getDeclaredConstructor(new Class[0]);
                    spc.setAccessible(true);
                    e.registerSpriteSet(type, spc.newInstance(new Object[0]));
                    return;
                }
                catch (ReflectiveOperationException ex) {
                    throw new ReportedException(new CrashReport("Unable to create ParticleProvider.Sprite(no-args) for ParticleType " + name, (Throwable)ex));
                }
            }
            for (Constructor<?> ctor : ctors = providerCls.getConstructors()) {
                if (ctor.getParameterCount() == 0) {
                    ctor.setAccessible(true);
                    try {
                        e.registerSpecial(type, (ParticleProvider)Cast.cast(ctor.newInstance(new Object[0])));
                    }
                    catch (ReflectiveOperationException ex) {
                        throw new ReportedException(new CrashReport("Unable to create ParticleProvider(no-args) for ParticleType " + name, (Throwable)ex));
                    }
                    return;
                }
                if (ctor.getParameterCount() != 1 || !SpriteSet.class.isAssignableFrom(ctor.getParameterTypes()[0])) continue;
                ctor.setAccessible(true);
                e.registerSpriteSet(type, set -> {
                    try {
                        return (ParticleProvider)Cast.cast(ctor.newInstance(set));
                    }
                    catch (ReflectiveOperationException ex) {
                        throw new ReportedException(new CrashReport("Unable to create ParticleProvider(no-args) for ParticleType " + name, (Throwable)ex));
                    }
                });
                return;
            }
        };
    }

    @SubscribeEvent
    public void renderWorldLast(RenderLevelStageEvent e) {
        if (!this.renderedWorld) {
            Network.sendToServer(new PacketPlayerReady());
            MinecraftForge.EVENT_BUS.post((Event)new ClientLoadedInEvent());
            this.renderedWorld = true;
        }
    }

    private void clientTick(TickEvent.ClientTickEvent e) {
        Minecraft mc = Minecraft.m_91087_();
        if (e.phase == TickEvent.Phase.START) {
            if (mc.f_91073_ != null) {
                if (!mc.m_91104_()) {
                    --this.pingTimer;
                    if (this.pingTimer <= 0) {
                        this.pingTimer += 40;
                        Network.sendToServer(new PingServerPacket(System.currentTimeMillis()));
                    }
                }
            } else if (this.renderedWorld) {
                this.renderedWorld = false;
                ConfigAdapter.resetClientsideSync();
            }
            return;
        }
        if (mc.f_91073_ == null) {
            this.clientTickTasks.clear();
        }
        for (int i = 0; i < this.clientTickTasks.size(); ++i) {
            if (!this.clientTickTasks.get(i).shouldRemove()) continue;
            this.clientTickTasks.remove(i);
            --i;
        }
    }

    @SubscribeEvent
    public void addF3Info(CustomizeGuiOverlayEvent.DebugText f3) {
        if (Minecraft.m_91087_().f_91066_.f_92063_) {
            ArrayList tip = f3.getLeft();
            tip.add(ChatFormatting.GOLD + "[HammerLib]" + ChatFormatting.RESET + " Ping: ~" + PingServerPacket.lastPingTime + " ms.");
        }
    }

    @Override
    public String getLanguage() {
        return Minecraft.m_91087_().f_91066_.f_92075_;
    }

    @Override
    public Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Override
    public ReloadableResourceManager getResourceManager() {
        if (LogicalSidePredictor.getCurrentLogicalSide() == LogicalSide.CLIENT) {
            return (ReloadableResourceManager)Minecraft.m_91087_().m_91098_();
        }
        return super.getResourceManager();
    }
}

