/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.net.PacketFactory;

public class PlainHLMessage {
    IPacket packet;

    public PlainHLMessage() {
    }

    public PlainHLMessage(IPacket packet) {
        this.packet = packet;
    }

    public PlainHLMessage(FriendlyByteBuf buf) {
        this.packet = PacketFactory.createEmpty(buf.m_130136_(256));
        if (this.packet != null) {
            this.packet.read(buf);
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(PacketFactory.getPacketId(this.packet));
        if (this.packet != null) {
            this.packet.write(buf);
        }
    }

    public boolean isValid() {
        return this.packet != null;
    }

    public IPacket unwrap() {
        return this.packet;
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        PacketContext pctx = new PacketContext(ctx);
        if (this.packet != null) {
            CompletableFuture<Object> exec;
            if (this.packet.executeOnMainThread()) {
                exec = ctx.enqueueWork(() -> this.packet.execute(pctx));
            } else {
                this.packet.execute(pctx);
                exec = CompletableFuture.completedFuture(null);
            }
            exec.thenRun(() -> {
                IPacket reply = pctx.getReply();
                if (reply != null) {
                    ctx.getPacketDispatcher().sendPacket(Network.MAIN_CHANNEL, Network.toBuffer(new PlainHLMessage(reply)));
                }
            });
            ctx.setPacketHandled(true);
        }
    }
}

