/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.recipes;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.zeith.hammerlib.core.init.RecipesHL;
import org.zeith.hammerlib.core.recipes.replacers.IRemainingItemReplacer;
import org.zeith.hammerlib.core.recipes.replacers.RemainingReplacerRegistrar;

public class HLShapelessRecipe
extends ShapelessRecipe {
    protected final List<IRemainingItemReplacer> inputModifier = new ArrayList<IRemainingItemReplacer>();

    public HLShapelessRecipe(ResourceLocation id, String group, CraftingBookCategory category, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(id, group, category, result, ingredients);
    }

    public HLShapelessRecipe addReplacer(ResourceLocation id) {
        IRemainingItemReplacer m = RemainingReplacerRegistrar.get(id);
        if (m != null) {
            this.inputModifier.add(m);
        }
        return this;
    }

    public HLShapelessRecipe addReplacers(ResourceLocation ... id) {
        for (ResourceLocation i : id) {
            this.inputModifier.add(RemainingReplacerRegistrar.get(i));
        }
        this.inputModifier.removeIf(Objects::isNull);
        return this;
    }

    public HLShapelessRecipe addReplacers(Iterable<ResourceLocation> id) {
        for (ResourceLocation i : id) {
            this.inputModifier.add(RemainingReplacerRegistrar.get(i));
        }
        this.inputModifier.removeIf(Objects::isNull);
        return this;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipesHL.SHAPELESS_HL_SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer ctr) {
        NonNullList remaining = super.m_7457_((Container)ctr);
        for (IRemainingItemReplacer replacer : this.inputModifier) {
            for (int i = 0; i < remaining.size(); ++i) {
                remaining.set(i, (Object)replacer.replace(ctr, i, (ItemStack)remaining.get(i)));
            }
        }
        return remaining;
    }

    public static class HLSerializer
    implements RecipeSerializer<HLShapelessRecipe> {
        public HLShapelessRecipe fromJson(ResourceLocation id, JsonObject json) {
            ShapelessRecipe base = (ShapelessRecipe)RecipeSerializer.f_44077_.m_6729_(id, json);
            HLShapelessRecipe mod = new HLShapelessRecipe(base.m_6423_(), base.m_6076_(), base.m_245232_(), (NonNullList<Ingredient>)base.m_7527_(), base.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
            if (json.has("hl_replacers")) {
                mod.inputModifier.addAll(RemainingReplacerRegistrar.fromJson(json.getAsJsonArray("hl_replacers")));
            }
            return mod;
        }

        public HLShapelessRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            ShapelessRecipe base = (ShapelessRecipe)RecipeSerializer.f_44077_.m_8005_(id, buf);
            HLShapelessRecipe mod = new HLShapelessRecipe(base.m_6423_(), base.m_6076_(), base.m_245232_(), (NonNullList<Ingredient>)base.m_7527_(), base.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
            mod.inputModifier.addAll(RemainingReplacerRegistrar.fromNetwork(buf));
            return mod;
        }

        public void toNetwork(FriendlyByteBuf buf, HLShapelessRecipe r) {
            RecipeSerializer.f_44077_.m_6178_(buf, (Recipe)r);
            RemainingReplacerRegistrar.toNetwork(r.inputModifier, buf);
        }
    }
}

