/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.js;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.core.js.converters.IJsConverter;
import org.zeith.hammerlib.core.js.math.IDoubleTest;
import org.zeith.hammerlib.core.js.parsers.FallbackJSParser;
import org.zeith.hammerlib.core.js.parsers.IJsParser;
import org.zeith.hammerlib.core.js.parsers.OpenJDKParser;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;

public class JsFactory {
    private static final List<IJsParser> PARSERS = Arrays.asList(new OpenJDKParser(), new FallbackJSParser());
    private static boolean loadedParser;
    private static boolean loadedConverter;
    private static IJsParser parser;
    private static IJsConverter converter;

    public static IJsParser getParser() {
        if (!loadedParser) {
            JsFactory.newEngine();
        }
        return parser;
    }

    public static IJsConverter getConverter() {
        if (loadedConverter) {
            return converter;
        }
        IJsParser parser = JsFactory.getParser();
        String expression = "a+b";
        String fun = "function get() {\n\treturn " + expression + ";\n}";
        for (IJsConverter c : parser.getConverters()) {
            ScriptEngine se = parser.create();
            try {
                se.put("a", 1);
                se.put("b", 2);
                IDoubleTest idt = c.parseAsInterface(se, fun, IDoubleTest.class);
                if (idt == null || !JsFactory.nearlyEq(idt.get(), 3.0)) continue;
                se.put("a", 2);
                se.put("b", 2);
                if (!JsFactory.nearlyEq(idt.get(), 4.0)) continue;
                HammerLib.LOG.info("JS Converter {} has passed!", (Object)c);
                loadedConverter = true;
                converter = c;
                return c;
            }
            catch (ScriptException e) {
                HammerLib.LOG.info("JS Converter {} has failed.", (Object)c);
            }
        }
        loadedConverter = true;
        return converter;
    }

    private static boolean nearlyEq(double a, double b) {
        return Math.abs(a - b) < 1.0E-4;
    }

    public static ScriptEngine newEngine() {
        if (!loadedParser) {
            for (IJsParser jsp : PARSERS) {
                ScriptEngine jse = jsp.create();
                if (jse == null) continue;
                parser = jsp;
                loadedParser = true;
                return jse;
            }
            loadedParser = true;
        }
        return parser != null ? parser.create() : null;
    }

    public static <T> Tuple2<ScriptEngine, T> parse(Class<T> interfaceType, Map<String, Object> properties, String expression) throws ScriptException {
        ScriptEngine se = JsFactory.newEngine();
        IJsConverter cs = JsFactory.getConverter();
        if (se == null || cs == null) {
            return null;
        }
        properties.forEach(se::put);
        T t = cs.parseAsInterface(se, expression, interfaceType);
        if (t == null) {
            return null;
        }
        return Tuples.immutable(se, t);
    }

    public static void init(boolean require) {
        IJsParser p = JsFactory.getParser();
        IJsConverter c = JsFactory.getConverter();
        if ((p == null || c == null) && require) {
            throw new IllegalStateException("Nashorn JS environment was not found.");
        }
        HammerLib.LOG.info("Using {} JS parser with {} converter.", (Object)p, (Object)c);
    }

    public static void isolateJava(Map<String, Object> props) {
        props.put("load", null);
        props.put("loadWithNewGlobal", null);
        props.put("exit", null);
        props.put("quit", null);
        props.put("Java", null);
        props.put("java", null);
        props.put("javax", null);
        props.put("javafx", null);
        props.put("org", null);
        props.put("com", null);
        props.put("edu", null);
    }
}

