/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.render.entity.player;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.zeith.hammerlib.util.java.net.HttpRequest;
import org.zeith.hammerlib.util.shaded.json.JSONTokener;

public final class EmissiveSkinHelper {
    private static final String USERNAME_TO_ID_CHECK = "https://skins.zeith.org/usernames/%s.json";
    private static final String UUID_TO_EMISSIVE = "https://skins.zeith.org/emissive/%s/%s/%s";

    private EmissiveSkinHelper() {
    }

    public static GameProfile adaptGameProfileToEmissiveTextures(GameProfile profile) {
        if (profile.getId() != null) {
            try (HttpRequest req = HttpRequest.head(EmissiveSkinHelper.getEmissiveRequestURL(profile.getId().toString(), "textures.json"));){
                if (req.isResponse2xx()) {
                    GameProfile gameProfile = profile;
                    return gameProfile;
                }
            }
        }
        String fburl = USERNAME_TO_ID_CHECK.formatted(profile.getName());
        try (HttpRequest req = HttpRequest.get(fburl);){
            if (req.isResponse2xx()) {
                GameProfile gameProfile = new GameProfile(new JSONTokener(req.body()).nextValueOBJ().map(j -> j.getString("uuid")).map(UUID::fromString).orElse(profile.getId()), profile.getName());
                return gameProfile;
            }
        }
        return profile;
    }

    public static EnumSet<MinecraftProfileTexture.Type> findEmissiveTextureTypes(String uuid) {
        try (HttpRequest req = HttpRequest.get(EmissiveSkinHelper.getEmissiveRequestURL(uuid, "textures.json"));){
            if (req.isResponse2xx()) {
                Set textures = new JSONTokener(req.body()).nextValueARR().stream().flatMap(arr -> StreamSupport.stream(arr.spliterator(), false)).map(Objects::toString).collect(Collectors.toSet());
                EnumSet<MinecraftProfileTexture.Type> enumSet = EnumSet.copyOf(Stream.of(MinecraftProfileTexture.Type.values()).filter(type -> textures.contains(type.name().toLowerCase(Locale.ROOT))).toList());
                return enumSet;
            }
        }
        return EnumSet.noneOf(MinecraftProfileTexture.Type.class);
    }

    public static String getEmissiveRequestURL(String uuid, MinecraftProfileTexture.Type textureType) {
        return EmissiveSkinHelper.getEmissiveRequestURL(uuid, textureType.name().toLowerCase(Locale.ROOT) + ".png");
    }

    private static String getEmissiveRequestURL(String uuid, String rawType) {
        return UUID_TO_EMISSIVE.formatted(uuid.substring(0, 2), uuid.replace("-", ""), rawType);
    }
}

