/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.model.builtin;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.zeith.hammerlib.client.model.IUnbakedGeometry;
import org.zeith.hammerlib.client.model.LoadUnbakedGeometry;
import org.zeith.hammerlib.client.model.QuadTransformingBakedModel;
import org.zeith.hammerlib.util.mcf.Resources;

@LoadUnbakedGeometry(path="emissive")
public class EmissiveGeometry
implements IUnbakedGeometry<EmissiveGeometry> {
    protected ResourceLocation parentLocation;
    protected UnbakedModel parent;
    protected int emissivity;
    protected final Map<ResourceLocation, ResourceLocation> textures = new HashMap<ResourceLocation, ResourceLocation>();

    public EmissiveGeometry(JsonObject obj, JsonDeserializationContext context) {
        if (obj.has("inline_parent") && obj.get("inline_parent").isJsonObject()) {
            this.parent = (UnbakedModel)context.deserialize((JsonElement)obj.getAsJsonObject("inline_parent"), BlockModel.class);
        } else {
            this.parentLocation = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)obj, (String)"parent"));
        }
        this.emissivity = GsonHelper.m_13824_((JsonObject)obj, (String)"emissivity", (int)15);
        if (obj.has("textures")) {
            JsonObject arr = obj.getAsJsonObject("textures");
            for (String id : arr.keySet()) {
                this.textures.put(Resources.location(id), Resources.location(GsonHelper.m_13906_((JsonObject)arr, (String)id)));
            }
        }
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        if (this.parent == null && this.parentLocation != null) {
            this.parent = modelGetter.apply(this.parentLocation);
        } else if (this.parent != null) {
            this.parent.m_5500_(modelGetter);
        }
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        BakedModel res = this.parent.m_7611_(baker, mat -> {
            ResourceLocation dTex = this.textures.getOrDefault(mat.m_119203_(), mat.m_119203_());
            if (dTex != null && !dTex.equals((Object)mat.m_119203_())) {
                mat = new Material(mat.m_119193_(), dTex);
            }
            return (TextureAtlasSprite)spriteGetter.apply((Material)mat);
        }, modelState, this.parentLocation != null ? this.parentLocation : modelLocation);
        return new QuadTransformingBakedModel(res, QuadTransformers.settingEmissivity((int)this.emissivity));
    }
}

