/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.readers;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.zeith.hammerlib.abstractions.props.KeyMap;
import org.zeith.hammerlib.annotations.ide.AllowJS;
import org.zeith.hammerlib.annotations.ide.AllowedValues;
import org.zeith.hammerlib.annotations.ide.Default;
import org.zeith.hammerlib.annotations.ide.FileReference;
import org.zeith.hammerlib.annotations.ide.Namespace;
import org.zeith.hammerlib.annotations.ide.Required;
import org.zeith.hammerlib.api.data.IDataNode;
import org.zeith.hammerlib.client.flowgui.FlowguiShaderRegistry;
import org.zeith.hammerlib.client.flowgui.objects.GuiImageObject;
import org.zeith.hammerlib.client.flowgui.reader.ComDrivers;
import org.zeith.hammerlib.client.flowgui.reader.DriverContext;
import org.zeith.hammerlib.client.flowgui.reader.FlowguiReader;
import org.zeith.hammerlib.client.flowgui.reader.GuiReader;
import org.zeith.hammerlib.util.java.Suppliers2;
import org.zeith.hammerlib.util.mcf.Resources;

@Namespace(value="hammerlib")
@FlowguiReader(value="image")
public class FlowguiImageReader
extends GuiReader<GuiImageObject> {
    @AllowJS
    @FileReference(regex={"^(?<modid>[a-z0-9_.-]+):(?<path>[a-z0-9_./-]+)$", "^(?<path>[a-z0-9_./-]+)$"}, value={"assets/%modid%/%path%", "assets/minecraft/%path%"})
    @AllowedValues(value={"^([a-z0-9_.-]+:[a-z0-9_./-]+)|([a-z0-9_./-]+)$"})
    @Required(value="minecraft:textures/gui/container/furnace.png")
    public static final String KEY_TEXTURE = "src";
    @AllowJS
    @AllowedValues(value={"^([a-z0-9_.-]+:[a-z0-9_./-]+)|([a-z0-9_./-]+)$"})
    @Default(value="minecraft:gui")
    public static final String KEY_SHADER = "shader";
    @AllowJS
    @AllowedValues(value={"^(0|[1-9]\\d*)(\\.\\d+)?$"})
    @Required(value="0")
    public static final String KEY_U_COORD = "u-coord";
    @AllowJS
    @AllowedValues(value={"^(0|[1-9]\\d*)(\\.\\d+)?$"})
    @Required(value="0")
    public static final String KEY_V_COORD = "v-coord";
    @AllowJS
    @AllowedValues(value={"^(0|[1-9]\\d*)(\\.\\d+)?$"})
    public static final String KEY_RENDER_WIDTH = "render-width";
    @AllowJS
    @AllowedValues(value={"^(0|[1-9]\\d*)(\\.\\d+)?$"})
    public static final String KEY_RENDER_HEIGHT = "render-height";
    @AllowJS
    @AllowedValues(value={"^(0|[1-9]\\d*)(\\.\\d+)?$"})
    @Required(value="176")
    public static final String KEY_IMAGE_WIDTH = "image-width";
    @AllowJS
    @AllowedValues(value={"^(0|[1-9]\\d*)(\\.\\d+)?$"})
    @Required(value="166")
    public static final String KEY_IMAGE_HEIGHT = "image-height";
    @AllowJS
    @AllowedValues(value={"^(0|[1-9]\\d*)(\\.\\d+)?$"})
    @Default(value="256")
    public static final String KEY_FILE_WIDTH = "file-width";
    @AllowJS
    @AllowedValues(value={"^(0|[1-9]\\d*)(\\.\\d+)?$"})
    @Default(value="256")
    public static final String KEY_FILE_HEIGHT = "file-height";

    @Override
    protected GuiImageObject readObject(KeyMap map, String name, IDataNode node) {
        AtomicReference<GuiImageObject> self = new AtomicReference<GuiImageObject>();
        DriverContext ctx = this.getDriverContext(map, node, self);
        Supplier<ResourceLocation> texture = Suppliers2.map(ComDrivers.readString(ctx, KEY_TEXTURE), Resources::locationOrNull);
        GuiImageObject image = new GuiImageObject(name, texture, 0.0f, 0.0f, 0.0f, 0.0f, 256.0f, 256.0f);
        self.set(image);
        ComDrivers.driveFloat(ctx, KEY_U_COORD, null, false, image.textureUOffset::set);
        ComDrivers.driveFloat(ctx, KEY_V_COORD, null, false, image.textureVOffset::set);
        boolean drivingWidth = ComDrivers.driveFloat(ctx, KEY_RENDER_WIDTH, null, false, image.elementWidth::set) || node.keys().contains(KEY_RENDER_WIDTH);
        boolean drivingHeight = ComDrivers.driveFloat(ctx, KEY_RENDER_HEIGHT, null, false, image.elementHeight::set) || node.keys().contains(KEY_RENDER_HEIGHT);
        ComDrivers.driveFloat(ctx, KEY_IMAGE_WIDTH, null, false, v -> {
            image.imageWidth.set(Float.valueOf(v));
            if (!drivingWidth) {
                image.elementWidth.set(Float.valueOf(v));
            }
        });
        ComDrivers.driveFloat(ctx, KEY_IMAGE_HEIGHT, null, false, v -> {
            image.imageHeight.set(Float.valueOf(v));
            if (!drivingHeight) {
                image.elementHeight.set(Float.valueOf(v));
            }
        });
        ComDrivers.driveFloat(ctx, KEY_FILE_WIDTH, Float.valueOf(256.0f), false, image.fileWidth::set);
        ComDrivers.driveFloat(ctx, KEY_FILE_HEIGHT, Float.valueOf(256.0f), false, image.fileHeight::set);
        ComDrivers.driveString(ctx, KEY_SHADER, "minecraft:gui", false, shader -> {
            image.shader = FlowguiShaderRegistry.get(Resources.locationOrNull(shader));
        });
        image.size(image.imgWidth, image.imgHeight);
        return image;
    }
}

