/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.objects;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.zeith.hammerlib.client.flowgui.FlowguiShaderRegistry;
import org.zeith.hammerlib.client.flowgui.Graphics;
import org.zeith.hammerlib.client.flowgui.GuiObject;
import org.zeith.hammerlib.client.flowgui.MousePos;
import org.zeith.hammerlib.util.java.DirectStorage;

public class GuiImageObject
extends GuiObject {
    public Supplier<ResourceLocation> tex;
    public float uOffset;
    public float vOffset;
    public float imgWidth;
    public float imgHeight;
    public float txWidth;
    public float txHeight;
    public Vec3 color = Vec3.m_82501_((int)-1);
    public float alpha = 1.0f;
    public final DirectStorage<Float> textureUOffset = DirectStorage.create(p -> {
        this.uOffset = p.floatValue();
    }, () -> Float.valueOf(this.uOffset));
    public final DirectStorage<Float> textureVOffset = DirectStorage.create(p -> {
        this.vOffset = p.floatValue();
    }, () -> Float.valueOf(this.vOffset));
    public final DirectStorage<Float> imageWidth = DirectStorage.create(p -> {
        this.imgWidth = p.floatValue();
    }, () -> Float.valueOf(this.imgWidth));
    public final DirectStorage<Float> imageHeight = DirectStorage.create(p -> {
        this.imgHeight = p.floatValue();
    }, () -> Float.valueOf(this.imgHeight));
    public final DirectStorage<Float> fileWidth = DirectStorage.create(p -> {
        this.txWidth = p.floatValue();
    }, () -> Float.valueOf(this.txWidth));
    public final DirectStorage<Float> fileHeight = DirectStorage.create(p -> {
        this.txHeight = p.floatValue();
    }, () -> Float.valueOf(this.txHeight));
    public int shaderTexture = 0;
    public Supplier<ShaderInstance> shader = FlowguiShaderRegistry.GUI_SHADER;

    public GuiImageObject(String name, Supplier<ResourceLocation> tex, float uOffset, float vOffset, float imgWidth, float imgHeight, float txWidth, float txHeight) {
        super(name);
        this.tex = tex;
        this.uOffset = uOffset;
        this.vOffset = vOffset;
        this.imgWidth = imgWidth;
        this.imgHeight = imgHeight;
        this.txWidth = txWidth;
        this.txHeight = txHeight;
        this.size(imgWidth, imgHeight);
    }

    public GuiImageObject shader(Supplier<ShaderInstance> shader) {
        this.shader = shader;
        return this;
    }

    public GuiImageObject shaderTexture(int shaderTexture) {
        this.shaderTexture = shaderTexture;
        return this;
    }

    @Override
    protected void render(Graphics gfx, MousePos pos) {
        gfx.drawManaged(() -> {
            RenderSystem.setShaderTexture((int)this.shaderTexture, (ResourceLocation)this.tex.get());
            GuiImageObject.blitWithBlend(this.shader, gfx.gfx(), this.uOffset, this.vOffset, this.width, this.height, this.imgWidth, this.imgHeight, this.txWidth, this.txHeight, this.alpha, this.color);
        });
    }

    public static void blitWithBlend(Supplier<ShaderInstance> shader, GuiGraphics gfx, float texPosX, float texPosY, float width, float height, float texWidth, float texHeight, float alpha, Vec3 rgb) {
        GuiImageObject.blitWithBlend(shader, gfx, texPosX, texPosY, width, height, width, height, texWidth, texHeight, alpha, rgb);
    }

    public static void blitWithBlend(Supplier<ShaderInstance> shader, GuiGraphics gfx, float texPosX, float texPosY, float renderWidth, float renderHeight, float spriteWidth, float spriteHeight, float texWidth, float texHeight, float alpha, Vec3 rgb) {
        BufferBuilder.RenderedBuffer batch;
        float u1 = texPosX / texWidth;
        float u2 = (texPosX + spriteWidth) / texWidth;
        float v1 = texPosY / texHeight;
        float v2 = (texPosY + spriteHeight) / texHeight;
        Matrix4f pose = gfx.m_280168_().m_85850_().m_252922_();
        BufferBuilder buf = Tesselator.m_85913_().m_85915_();
        if (buf.m_85732_() && (batch = buf.m_231168_()) != null) {
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)batch);
        }
        RenderSystem.enableBlend();
        RenderSystem.setShader(shader);
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        float r = (float)rgb.m_7096_();
        float g = (float)rgb.m_7098_();
        float b = (float)rgb.m_7094_();
        buf.m_252986_(pose, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(u1, v1).m_5752_();
        buf.m_252986_(pose, 0.0f, renderHeight, 0.0f).m_85950_(r, g, b, alpha).m_7421_(u1, v2).m_5752_();
        buf.m_252986_(pose, renderWidth, renderHeight, 0.0f).m_85950_(r, g, b, alpha).m_7421_(u2, v2).m_5752_();
        buf.m_252986_(pose, renderWidth, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(u2, v1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        RenderSystem.disableBlend();
    }
}

