/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.objects;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.zeith.hammerlib.client.flowgui.Graphics;
import org.zeith.hammerlib.client.flowgui.GuiObject;
import org.zeith.hammerlib.client.flowgui.MousePos;
import org.zeith.hammerlib.client.utils.GLStencil;
import org.zeith.hammerlib.util.math.Point;

public class GuiButtonObject
extends GuiObject {
    public static final int UNSET_FG_COLOR = -1;
    public float alpha;
    protected int packedFGColor;
    public boolean enabled;
    public Component message;
    public OnPress callback;
    public Supplier<SoundEvent> pressSound;
    public float pressSoundPitch = 1.0f;

    public GuiButtonObject(@NotNull String name, float alpha, int packedFGColor, boolean enabled, @NotNull Component message, @NotNull OnPress callback, Supplier<SoundEvent> pressSound, Float pressSoundPitch) {
        super(name);
        this.alpha = alpha;
        this.packedFGColor = packedFGColor;
        this.enabled = enabled;
        this.message = message;
        this.callback = callback;
        this.pressSound = pressSound;
        if (pressSoundPitch != null) {
            this.pressSoundPitch = pressSoundPitch.floatValue();
        }
    }

    public GuiButtonObject setAlpha(float alpha) {
        this.alpha = alpha;
        return this;
    }

    public GuiButtonObject setPackedFGColor(int packedFGColor) {
        this.packedFGColor = packedFGColor;
        return this;
    }

    @Override
    public GuiButtonObject setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public GuiButtonObject setMessage(Component message) {
        this.message = message;
        return this;
    }

    public GuiButtonObject setPressSoundPitch(float pressSoundPitch) {
        this.pressSoundPitch = pressSoundPitch;
        return this;
    }

    public static ButtonBuilder builder(String name) {
        return new ButtonBuilder().name(name).alpha(1.0f).packedFGColor(-1).enabled(true).message((Component)Component.m_237119_()).callback(OnPress.NONE).pressSound((Supplier<SoundEvent>)SoundEvents.f_12490_);
    }

    @Override
    protected void render(Graphics gfx, MousePos pos) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.renderButtonBg(gfx, pos);
        int i = this.getFGColor();
        this.renderString(gfx.gfx(), minecraft.f_91062_, i | Mth.m_14167_((float)(this.alpha * 255.0f)) << 24);
    }

    protected void renderButtonBg(Graphics pGfx, MousePos pos) {
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        pGfx.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        pGfx.blitNineSliced(AbstractWidget.f_93617_, 0, 0, (int)this.width, (int)this.height, 20, 4, 200, 20, 0, this.getTextureY(pos.isMouseWithin(this)));
        pGfx.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void onPress() {
        this.callback.onPress(this);
        this.playDownSound(Minecraft.m_91087_().m_91106_());
    }

    @Override
    protected boolean onMouseClicked(Point globalMousePos, MousePos pos, int button, boolean fake) {
        if (button == 0 && this.enabled && pos.isMouseWithin(this)) {
            if (!fake) {
                this.onPress();
            }
            return true;
        }
        return fake && this.enabled && pos.isMouseWithin(this);
    }

    public void playDownSound(SoundManager pHandler) {
        SoundEvent snd;
        if (this.pressSound != null && (snd = this.pressSound.get()) != null) {
            pHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)snd, (float)this.pressSoundPitch));
        }
    }

    protected int getTextureY(boolean hovered) {
        int i = 1;
        if (!this.enabled) {
            i = 0;
        } else if (hovered) {
            i = 2;
        }
        return 46 + i * 20;
    }

    public int getFGColor() {
        if (this.packedFGColor != -1) {
            return this.packedFGColor;
        }
        return this.enabled ? 0xFFFFFF : 0xA0A0A0;
    }

    public void renderString(GuiGraphics pGuiGraphics, Font pFont, int pColor) {
        this.renderScrollingString(pGuiGraphics, pFont, 2, pColor);
    }

    protected void renderScrollingString(GuiGraphics pGuiGraphics, Font pFont, int pWidth, int pColor) {
        int i = pWidth;
        int j = (int)(this.width - (float)pWidth);
        GuiButtonObject.renderScrollingString(pGuiGraphics, pFont, this.message, i, 0, j, (int)this.height, pColor);
    }

    protected static void renderScrollingString(GuiGraphics pGuiGraphics, Font pFont, Component pText, int pMinX, int pMinY, int pMaxX, int pMaxY, int pColor) {
        int i = pFont.m_92852_((FormattedText)pText);
        int j = (pMinY + pMaxY - 9) / 2 + 1;
        int k = pMaxX - pMinX;
        if (i > k) {
            int l = i - k;
            double d0 = (double)Util.m_137550_() / 1000.0;
            double d1 = Math.max((double)l * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double d3 = Mth.m_14139_((double)d2, (double)0.0, (double)l);
            if (GLStencil.isEnabled()) {
                try (GLStencil stencil = GLStencil.of();){
                    stencil.populateStencil(pGuiGraphics, gfx -> gfx.m_280509_(pMinX, pMinY, pMaxX, pMaxY, -1));
                    stencil.renderWithStencil(() -> pGuiGraphics.m_280430_(pFont, pText, pMinX - (int)d3, j, pColor));
                }
            } else {
                Matrix4f mat = pGuiGraphics.m_280168_().m_85850_().m_252922_();
                Vector3f v1Pos = mat.transformPosition((float)pMinX, (float)pMinY, 0.0f, new Vector3f());
                Vector3f v2Pos = mat.transformPosition((float)pMaxX, (float)pMinY, 0.0f, new Vector3f());
                Vector3f v3Pos = mat.transformPosition((float)pMaxX, (float)pMaxY, 0.0f, new Vector3f());
                Vector3f v4Pos = mat.transformPosition((float)pMinX, (float)pMaxY, 0.0f, new Vector3f());
                float minX = Math.min(v1Pos.x, Math.min(v2Pos.x, Math.min(v3Pos.x, v4Pos.x)));
                float minY = Math.min(v1Pos.y, Math.min(v2Pos.y, Math.min(v3Pos.y, v4Pos.y)));
                float maxX = Math.max(v1Pos.x, Math.max(v2Pos.x, Math.max(v3Pos.x, v4Pos.x)));
                float maxY = Math.max(v1Pos.y, Math.max(v2Pos.y, Math.max(v3Pos.y, v4Pos.y)));
                pGuiGraphics.m_280588_((int)minX, (int)minY, (int)maxX, (int)maxY);
                pGuiGraphics.m_280430_(pFont, pText, pMinX - (int)d3, j, pColor);
                pGuiGraphics.m_280618_();
            }
        } else {
            pGuiGraphics.m_280653_(pFont, pText, (pMinX + pMaxX) / 2, j, pColor);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnPress {
        public static final OnPress NONE = b -> {};

        public void onPress(GuiButtonObject var1);
    }

    public static class ButtonBuilder {
        @Generated
        private String name;
        @Generated
        private float alpha;
        @Generated
        private int packedFGColor;
        @Generated
        private boolean enabled;
        @Generated
        private Component message;
        @Generated
        private OnPress callback;
        @Generated
        private Supplier<SoundEvent> pressSound;
        @Generated
        private Float pressSoundPitch;

        private ButtonBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        ButtonBuilder() {
        }

        @Generated
        public ButtonBuilder alpha(float alpha) {
            this.alpha = alpha;
            return this;
        }

        @Generated
        public ButtonBuilder packedFGColor(int packedFGColor) {
            this.packedFGColor = packedFGColor;
            return this;
        }

        @Generated
        public ButtonBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Generated
        public ButtonBuilder message(@NotNull Component message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
            return this;
        }

        @Generated
        public ButtonBuilder callback(@NotNull OnPress callback) {
            if (callback == null) {
                throw new NullPointerException("callback is marked non-null but is null");
            }
            this.callback = callback;
            return this;
        }

        @Generated
        public ButtonBuilder pressSound(Supplier<SoundEvent> pressSound) {
            this.pressSound = pressSound;
            return this;
        }

        @Generated
        public ButtonBuilder pressSoundPitch(Float pressSoundPitch) {
            this.pressSoundPitch = pressSoundPitch;
            return this;
        }

        @Generated
        public GuiButtonObject build() {
            return new GuiButtonObject(this.name, this.alpha, this.packedFGColor, this.enabled, this.message, this.callback, this.pressSound, this.pressSoundPitch);
        }

        @Generated
        public String toString() {
            return "GuiButtonObject.ButtonBuilder(name=" + this.name + ", alpha=" + this.alpha + ", packedFGColor=" + this.packedFGColor + ", enabled=" + this.enabled + ", message=" + this.message + ", callback=" + this.callback + ", pressSound=" + this.pressSound + ", pressSoundPitch=" + this.pressSoundPitch + ")";
        }
    }
}

