/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.data;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;

public class GuiSlotHelper {
    public static int MAIN_INVENTORY_SLOT_COUNT = 27;
    public static int HOTBAR_INVENTORY_SLOT_COUNT = Inventory.m_36059_();
    public static int ARMOR_INVENTORY_SLOT_COUNT = 4;
    public static int OFFHAND_INVENTORY_SLOT_COUNT = 1;
    public final int[] playerInventorySlots = new int[MAIN_INVENTORY_SLOT_COUNT];
    public final int[] playerHotbarSlots = new int[HOTBAR_INVENTORY_SLOT_COUNT];
    public final int[] playerArmorSlots = new int[ARMOR_INVENTORY_SLOT_COUNT];
    public final int[] playerOffhandSlots = new int[OFFHAND_INVENTORY_SLOT_COUNT];
    public final int[] guiSlots;

    public GuiSlotHelper(@NotNull AbstractContainerMenu menu) {
        Arrays.fill(this.playerInventorySlots, -1);
        Arrays.fill(this.playerHotbarSlots, -1);
        Arrays.fill(this.playerArmorSlots, -1);
        Arrays.fill(this.playerOffhandSlots, -1);
        IntArrayList guiSlots = new IntArrayList();
        NonNullList sl = menu.f_38839_;
        int len = sl.size();
        for (int i = 0; i < len; ++i) {
            Slot slot = (Slot)sl.get(i);
            if (slot.f_40218_ instanceof Inventory) {
                int prev;
                int index = slot.getSlotIndex();
                if (index < (prev = 0) + HOTBAR_INVENTORY_SLOT_COUNT) {
                    this.playerHotbarSlots[index - prev] = i;
                    continue;
                }
                if (index < (prev += HOTBAR_INVENTORY_SLOT_COUNT) + MAIN_INVENTORY_SLOT_COUNT) {
                    this.playerInventorySlots[index - prev] = i;
                    continue;
                }
                if (index < (prev += MAIN_INVENTORY_SLOT_COUNT) + ARMOR_INVENTORY_SLOT_COUNT) {
                    this.playerArmorSlots[index - prev] = i;
                    continue;
                }
                if (index < (prev += ARMOR_INVENTORY_SLOT_COUNT) + OFFHAND_INVENTORY_SLOT_COUNT) {
                    this.playerOffhandSlots[index - prev] = i;
                    continue;
                }
                prev += OFFHAND_INVENTORY_SLOT_COUNT;
                continue;
            }
            guiSlots.add(i);
        }
        this.guiSlots = guiSlots.toIntArray();
    }
}

