/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.abstractions.recipes.IRecipeVisualizer;
import org.zeith.hammerlib.abstractions.recipes.IVisualizedRecipeType;
import org.zeith.hammerlib.api.fml.ICustomRegistrar;
import org.zeith.hammerlib.api.recipes.IngredientWithCount;
import org.zeith.hammerlib.util.java.Cast;

public abstract class SerializableRecipeType<T extends Recipe<?>>
implements RecipeType<T>,
RecipeSerializer<T>,
ICustomRegistrar,
IVisualizedRecipeType<T> {
    public static final String DEFAULT_INGREDIENTS_KEY = "ingredients";
    public static final String DEFAULT_INGREDIENT_KEY = "ingredient";
    public static final String DEFAULT_OUTPUT_KEY = "result";
    public static final String DEFAULT_GROUP_KEY = "group";

    public abstract T m_6729_(ResourceLocation var1, JsonObject var2);

    @Nullable
    public abstract T m_8005_(ResourceLocation var1, FriendlyByteBuf var2);

    public abstract void m_6178_(FriendlyByteBuf var1, T var2);

    @Override
    public void performRegister(RegisterEvent event, ResourceLocation id) {
        event.register(ForgeRegistries.Keys.RECIPE_TYPES, id, Cast.constant(this));
        event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, id, Cast.constant(this));
    }

    @Override
    public void initVisuals(Consumer<IRecipeVisualizer<T, ?>> viualizerConsumer) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{recipeTypeId=" + ForgeRegistries.RECIPE_TYPES.getKey((Object)this) + ",recipeSerializerId=" + ForgeRegistries.RECIPE_SERIALIZERS.getKey((Object)this) + "}";
    }

    public ItemStack getToastSymbol(Recipe<?> recipe) {
        return new ItemStack((ItemLike)Blocks.f_50091_);
    }

    public static Ingredient ingredientFromJson(JsonElement obj) {
        return Ingredient.m_43917_((JsonElement)obj);
    }

    public static NonNullList<Ingredient> ingredientsFromArray(JsonArray array) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < array.size(); ++i) {
            nonnulllist.add((Object)Ingredient.m_43917_((JsonElement)array.get(i)));
        }
        return nonnulllist;
    }

    public static NonNullList<IngredientWithCount> ingredientsWithCountFromArray(JsonArray array) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < array.size(); ++i) {
            nonnulllist.add((Object)IngredientWithCount.fromJson(array.get(i)));
        }
        return nonnulllist;
    }

    public static ItemStack itemStackFromJson(JsonObject obj) {
        return CraftingHelper.getItemStack((JsonObject)obj, (boolean)true, (boolean)true);
    }

    public static ItemStack itemStackOrEmptyFromJson(JsonObject obj) {
        return CraftingHelper.getItemStack((JsonObject)obj, (boolean)true, (boolean)false);
    }

    public static Item itemFromJson(JsonObject obj) {
        String s = GsonHelper.m_13906_((JsonObject)obj, (String)"item");
        Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (item == Items.f_41852_) {
            throw new JsonSyntaxException("Invalid item: " + s);
        }
        return item;
    }
}

