/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.recipes;

import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.zeith.hammerlib.api.recipes.SerializableRecipeType;

public abstract class BaseRecipe<R extends BaseRecipe<R>>
implements Recipe<Container> {
    protected final SerializableRecipeType<R> type = this.getRecipeType();
    protected final ResourceLocation id;
    protected String group = "";
    protected boolean isHidden;
    protected NonNullList<Ingredient> vanillaIngredients = NonNullList.m_122779_();
    protected ItemStack vanillaResult = ItemStack.f_41583_;

    public BaseRecipe(ResourceLocation id, String group) {
        this.id = Objects.requireNonNull(id, "Recipe ID can not be null.");
        this.group = group == null ? "" : group;
    }

    protected abstract SerializableRecipeType<R> getRecipeType();

    public NonNullList<Ingredient> m_7527_() {
        return this.vanillaIngredients;
    }

    public boolean m_5598_() {
        return this.isHidden;
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8042_() {
        return this.type.getToastSymbol(this);
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container container, RegistryAccess access) {
        return this.vanillaResult.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.vanillaResult.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.type;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }
}

