/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.api.proxy;

import io.github.kosmx.emotes.api.proxy.EmotesProxyManager;
import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.common.network.EmotePacket;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nullable;

public abstract class AbstractNetworkInstance
implements INetworkInstance {
    protected int remoteVersion = 0;
    protected boolean disableNBS = false;
    protected boolean doesServerTrackEmotePlay = false;
    protected int animationFormat = 1;

    protected void sendMessage(byte[] bytes, @Nullable UUID target) {
        throw new UnsupportedOperationException("You should have implemented send emote feature");
    }

    protected void sendMessage(ByteBuffer byteBuffer, @Nullable UUID target) {
        this.sendMessage(AbstractNetworkInstance.safeGetBytesFromBuffer(byteBuffer), target);
    }

    @Override
    public void sendMessage(EmotePacket.Builder builder, @Nullable UUID target) throws IOException {
        this.sendMessage(builder.build().write(), target);
    }

    public void receiveMessage(byte[] bytes) {
        this.receiveMessage(bytes, null);
    }

    public void receiveMessage(byte[] bytes, UUID player) {
        this.receiveMessage(ByteBuffer.wrap(bytes), player);
    }

    protected void disconnect() {
        EmotesProxyManager.disconnectInstance(this);
    }

    public static byte[] safeGetBytesFromBuffer(ByteBuffer byteBuffer) {
        return INetworkInstance.safeGetBytesFromBuffer(byteBuffer);
    }

    @Override
    public int getRemoteVersion() {
        return 8;
    }

    @Override
    public void setVersions(HashMap<Byte, Byte> map) {
        if (map.containsKey((byte)3)) {
            boolean bl = this.disableNBS = map.get((byte)3) == 0;
        }
        if (map.containsKey((byte)8)) {
            this.remoteVersion = map.get((byte)8).byteValue();
        }
        if (map.containsKey((byte)-128)) {
            boolean bl = this.doesServerTrackEmotePlay = map.get((byte)-128) != 0;
        }
        if (map.containsKey((byte)0)) {
            this.animationFormat = map.get((byte)0).byteValue();
        }
    }

    @Override
    public HashMap<Byte, Byte> getRemoteVersions() {
        HashMap<Byte, Byte> map = new HashMap<Byte, Byte>();
        if (this.disableNBS) {
            map.put((byte)3, (byte)0);
        }
        if (this.doesServerTrackEmotePlay) {
            map.put((byte)-128, (byte)1);
        }
        map.put((byte)0, (byte)this.animationFormat);
        return map;
    }

    @Override
    public boolean isServerTrackingPlayState() {
        return this.doesServerTrackEmotePlay;
    }

    @Override
    public void sendConfigCallback() {
        EmotePacket.Builder packetBuilder = new EmotePacket.Builder();
        packetBuilder.configureToConfigExchange(true);
        try {
            this.sendMessage(packetBuilder, null);
        }
        catch (Exception e) {
            EmotesProxyManager.log(Level.WARNING, "Error while writing packet: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public int maxDataSize() {
        return Short.MAX_VALUE;
    }
}

