/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerSkinHelper {
    private static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(0, 5, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());

    public static void updateGameProfileAsync(@Nullable GameProfile input, @NotNull Consumer<GameProfile> callback) {
        if (input != null) {
            if (input.isComplete() && input.getProperties().containsKey((Object)"textures")) {
                callback.accept(input);
            } else if (SkullBlockEntity.f_59755_ != null && SkullBlockEntity.f_59756_ != null) {
                THREAD_POOL.submit(() -> {
                    GameProfile gameprofile = (input.getId() == null ? SkullBlockEntity.f_59755_.m_10996_(input.getName()) : SkullBlockEntity.f_59755_.m_11002_(input.getId())).orElse(input);
                    Property property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), null);
                    if (property == null) {
                        gameprofile = SkullBlockEntity.f_59756_.fillProfileProperties(gameprofile, true);
                    }
                    callback.accept(gameprofile);
                });
            } else {
                callback.accept(input);
            }
        } else {
            callback.accept(input);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void obtainPlayerSkinPropertiesAsync(GameProfile input, @NotNull Consumer<Pair<ResourceLocation, Boolean>> callback) {
        PlayerSkinHelper.updateGameProfileAsync(input, p -> {
            boolean alex;
            ResourceLocation loc;
            Map map = Minecraft.m_91087_().m_91109_().m_118815_(p);
            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                MinecraftProfileTexture t = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
                loc = Minecraft.m_91087_().m_91109_().m_118825_(t, MinecraftProfileTexture.Type.SKIN);
                alex = "slim".equals(t.getMetadata("model"));
            } else {
                loc = DefaultPlayerSkin.m_118627_((UUID)p.getId());
                alex = "slim".equals(DefaultPlayerSkin.m_118629_((UUID)p.getId()));
            }
            callback.accept(Pair.of((Object)loc, (Object)alex));
        });
    }
}

