/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import com.mojang.datafixers.util.Either;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public record ServerboundStartFeedingPacket(Either<Integer, BlockPos> target) implements IMessage.IServerBoundMessage
{
    public ServerboundStartFeedingPacket(int entityID) {
        this((Either<Integer, BlockPos>)Either.left((Object)entityID));
    }

    public ServerboundStartFeedingPacket(BlockPos targetPosition) {
        this((Either<Integer, BlockPos>)Either.right((Object)targetPosition));
    }

    static void encode(@NotNull ServerboundStartFeedingPacket msg, @NotNull FriendlyByteBuf buffer) {
        msg.target.ifLeft(entityID -> {
            buffer.writeBoolean(false);
            buffer.m_130130_(entityID.intValue());
        });
        msg.target.ifRight(targetPos -> {
            buffer.writeBoolean(true);
            buffer.m_130064_(targetPos);
        });
    }

    @NotNull
    static ServerboundStartFeedingPacket decode(@NotNull FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            return new ServerboundStartFeedingPacket(buffer.m_130135_());
        }
        return new ServerboundStartFeedingPacket(buffer.m_130242_());
    }

    static void handle(@NotNull ServerboundStartFeedingPacket msg, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayer player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> VampirePlayer.getOpt((Player)player).ifPresent(vampire -> {
            msg.target.ifLeft(vampire::biteEntity);
            msg.target.ifRight(vampire::biteBlock);
        }));
        ctx.setPacketHandled(true);
    }
}

