/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.items.IVampirismCrossbow;
import de.teamlapen.vampirism.client.gui.screens.SelectAmmoScreen;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ServerboundSelectAmmoTypePacket(boolean hasRestriction, @Nullable ResourceLocation ammoId) implements IMessage.IServerBoundMessage
{
    public ServerboundSelectAmmoTypePacket(boolean hasRestriction, @Nullable ResourceLocation ammoId) {
        this.hasRestriction = hasRestriction;
        this.ammoId = ammoId;
        if (hasRestriction) {
            Objects.requireNonNull(ammoId);
        }
    }

    static void encode(@NotNull ServerboundSelectAmmoTypePacket msg, @NotNull FriendlyByteBuf buf) {
        buf.writeBoolean(msg.hasRestriction);
        if (msg.hasRestriction) {
            buf.m_130085_(msg.ammoId);
        }
    }

    static ServerboundSelectAmmoTypePacket decode(@NotNull FriendlyByteBuf buf) {
        boolean hasRestrictions;
        return new ServerboundSelectAmmoTypePacket(hasRestrictions, (hasRestrictions = buf.readBoolean()) ? buf.m_130281_() : null);
    }

    static void handle(@NotNull ServerboundSelectAmmoTypePacket msg, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayer player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> {
            IVampirismCrossbow crossbow;
            ItemStack stack = player.m_21205_();
            Item patt2152$temp = stack.m_41720_();
            if (patt2152$temp instanceof IVampirismCrossbow && (crossbow = (IVampirismCrossbow)patt2152$temp).canSelectAmmunition(stack)) {
                crossbow.setAmmunition(stack, msg.ammoId);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static ServerboundSelectAmmoTypePacket of(SelectAmmoScreen.AmmoType ammoType) {
        if (ammoType.renderStack == null) {
            return new ServerboundSelectAmmoTypePacket(false, null);
        }
        return new ServerboundSelectAmmoTypePacket(true, RegUtil.id(ammoType.renderStack.m_41720_()));
    }
}

