/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ServerboundActionBindingPacket(int actionBindingId, @Nullable IAction<?> action) implements IMessage.IServerBoundMessage
{
    static void encode(@NotNull ServerboundActionBindingPacket msg, @NotNull FriendlyByteBuf buf) {
        buf.m_130130_(msg.actionBindingId);
        buf.writeBoolean(msg.action != null);
        if (msg.action != null) {
            buf.m_130085_(RegUtil.id(msg.action));
        }
    }

    @NotNull
    static ServerboundActionBindingPacket decode(@NotNull FriendlyByteBuf buf) {
        return new ServerboundActionBindingPacket(buf.m_130242_(), buf.readBoolean() ? RegUtil.getAction(buf.m_130281_()) : null);
    }

    public static void handle(@NotNull ServerboundActionBindingPacket msg, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> FactionPlayerHandler.getOpt((Player)ctx.getSender()).ifPresent(factionPlayerHandler -> factionPlayerHandler.setBoundAction(msg.actionBindingId, msg.action, false, false)));
        ctx.setPacketHandled(true);
    }
}

