/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.world.MultiBossEvent;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.BossEvent;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public record ClientboundUpdateMultiBossEventPacket(UUID uniqueId, OperationType operation, List<Color> colors, Map<Color, Float> entries, Component name, BossEvent.BossBarOverlay overlay) implements IMessage.IClientBoundMessage
{
    public ClientboundUpdateMultiBossEventPacket(OperationType operation, @NotNull MultiBossEvent data) {
        this(data.getUniqueId(), operation, data.getColors(), data.getEntries(), data.getName(), data.getOverlay());
    }

    static void encode(@NotNull ClientboundUpdateMultiBossEventPacket msg, @NotNull FriendlyByteBuf buf) {
        buf.m_130077_(msg.uniqueId);
        buf.m_130068_((Enum)msg.operation);
        switch (msg.operation) {
            case ADD: {
                buf.m_130083_(msg.name);
                buf.m_130130_(msg.colors.size());
                msg.colors.forEach(color -> buf.m_130130_(color.getRGB()));
                buf.m_130068_((Enum)msg.overlay);
            }
            case UPDATE_PROGRESS: {
                buf.m_130130_(msg.entries.size());
                for (Map.Entry<Color, Float> value : msg.entries.entrySet()) {
                    buf.m_130130_(value.getKey().getRGB());
                    buf.writeFloat(value.getValue().floatValue());
                }
                break;
            }
            case UPDATE_NAME: {
                buf.m_130083_(msg.name);
                break;
            }
            case UPDATE_STYLE: {
                buf.m_130068_((Enum)msg.overlay);
            }
        }
    }

    @NotNull
    static ClientboundUpdateMultiBossEventPacket decode(@NotNull FriendlyByteBuf buf) {
        UUID uuid = buf.m_130259_();
        OperationType operation = (OperationType)buf.m_130066_(OperationType.class);
        Component name = null;
        List colors = null;
        Map entries = null;
        BossEvent.BossBarOverlay overlay = null;
        switch (operation) {
            case ADD: {
                name = buf.m_130238_();
                int size = buf.m_130242_();
                LinkedList<Color> colorsList = new LinkedList<Color>();
                for (int i = 0; i < size; ++i) {
                    colorsList.add(new Color(buf.m_130242_(), true));
                }
                colors = Collections.unmodifiableList(colorsList);
                overlay = (BossEvent.BossBarOverlay)buf.m_130066_(BossEvent.BossBarOverlay.class);
            }
            case UPDATE_PROGRESS: {
                LinkedHashMap<Color, Float> entriesMap = new LinkedHashMap<Color, Float>();
                int size2 = buf.m_130242_();
                for (int i = 0; i < size2; ++i) {
                    Color color = new Color(buf.m_130242_(), true);
                    float perc = buf.readFloat();
                    entriesMap.put(color, Float.valueOf(perc));
                }
                entries = Collections.unmodifiableMap(entriesMap);
                break;
            }
            case UPDATE_NAME: {
                name = buf.m_130238_();
                break;
            }
            case UPDATE_STYLE: {
                overlay = (BossEvent.BossBarOverlay)buf.m_130066_(BossEvent.BossBarOverlay.class);
            }
        }
        return new ClientboundUpdateMultiBossEventPacket(uuid, operation, colors, entries, name, overlay);
    }

    public static void handle(ClientboundUpdateMultiBossEventPacket msg, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleUpdateMultiBossInfoPacket(msg));
        ctx.setPacketHandled(true);
    }

    public static enum OperationType {
        ADD,
        REMOVE,
        UPDATE_PROGRESS,
        UPDATE_NAME,
        UPDATE_STYLE,
        UPDATE_PROPERTIES;

    }
}

