/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.entity.SundamageRegistry;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public record ClientboundSundamagePacket(List<ResourceKey<DimensionType>> dimensions, List<ResourceKey<Biome>> biomes, List<ResourceKey<Level>> noSunDamageLevels, List<ResourceKey<Level>> sunDamageLevels) implements IMessage.IClientBoundMessage
{
    public static final Codec<ClientboundSundamagePacket> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256787_).listOf().fieldOf("dimensions").forGetter(ClientboundSundamagePacket::dimensions), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256952_).listOf().fieldOf("biomes").forGetter(ClientboundSundamagePacket::biomes), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).listOf().fieldOf("noSunDamageLevels").forGetter(ClientboundSundamagePacket::noSunDamageLevels), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).listOf().fieldOf("sunDamageLevels").forGetter(ClientboundSundamagePacket::sunDamageLevels)).apply((Applicative)inst, ClientboundSundamagePacket::new));

    static void encode(@NotNull ClientboundSundamagePacket msg, @NotNull FriendlyByteBuf buf) {
        buf.m_272073_(CODEC, (Object)msg);
    }

    @NotNull
    static ClientboundSundamagePacket decode(@NotNull FriendlyByteBuf buf) {
        return (ClientboundSundamagePacket)buf.m_271872_(CODEC);
    }

    public static void handle(@NotNull ClientboundSundamagePacket msg, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ((SundamageRegistry)VampirismAPI.sundamageRegistry()).applyNetworkData(msg));
        context.setPacketHandled(true);
    }
}

