/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.blockentity.TentBlockEntity;
import de.teamlapen.vampirism.blocks.TentBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TentItem
extends Item {
    private final boolean spawner;

    public static boolean placeAt(@NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull Direction dir, boolean force, boolean spawner) {
        boolean flag;
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        int x1 = x + (dir == Direction.SOUTH ? 1 : (dir == Direction.NORTH ? -1 : 0));
        int z1 = z + (dir == Direction.WEST ? 1 : (dir == Direction.EAST ? -1 : 0));
        int x2 = x + (dir == Direction.WEST ? -1 : (dir == Direction.NORTH ? -1 : 1));
        int z2 = z + (dir == Direction.SOUTH || dir == Direction.WEST ? 1 : -1);
        int x3 = x + (dir == Direction.WEST ? -1 : (dir == Direction.EAST ? 1 : 0));
        int z3 = z + (dir == Direction.SOUTH ? 1 : (dir == Direction.NORTH ? -1 : 0));
        Block tent = (Block)ModBlocks.TENT.get();
        Block main = (Block)ModBlocks.TENT_MAIN.get();
        BlockState mainState = main.m_49966_();
        if ((force || TentItem.canPlaceAt(mainState, tent, world, x, y, z) && TentItem.canPlaceAt(mainState, tent, world, x1, y, z1) && TentItem.canPlaceAt(mainState, tent, world, x2, y, z2) && TentItem.canPlaceAt(mainState, tent, world, x3, y, z3)) && (flag = world.m_7731_(pos, (BlockState)main.m_49966_().m_61124_((Property)TentBlock.FACING, (Comparable)dir.m_122424_()), 3))) {
            BlockEntity tile;
            world.m_7731_(new BlockPos(x1, y, z1), (BlockState)((BlockState)tent.m_49966_().m_61124_((Property)TentBlock.FACING, (Comparable)dir)).m_61124_((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(1)), 3);
            world.m_7731_(new BlockPos(x2, y, z2), (BlockState)((BlockState)tent.m_49966_().m_61124_((Property)TentBlock.FACING, (Comparable)dir)).m_61124_((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(2)), 3);
            world.m_7731_(new BlockPos(x3, y, z3), (BlockState)((BlockState)tent.m_49966_().m_61124_((Property)TentBlock.FACING, (Comparable)dir.m_122424_())).m_61124_((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(3)), 3);
            if (spawner && (tile = world.m_7702_(pos)) instanceof TentBlockEntity) {
                ((TentBlockEntity)tile).setSpawn(true);
            }
            return true;
        }
        return false;
    }

    private static boolean canPlaceAt(@NotNull BlockState state, @NotNull Block block, @NotNull LevelAccessor world, int x, int y, int z) {
        return block.m_7898_(state, (LevelReader)world, new BlockPos(x, y, z));
    }

    public TentItem(boolean spawner) {
        super(new Item.Properties());
        this.spawner = spawner;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (this.spawner) {
            tooltip.add((Component)Component.m_237115_((String)"tile.vampirism.tent.spawner").m_130940_(ChatFormatting.GRAY));
        }
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext ctx) {
        if (ctx.m_43719_() != Direction.UP) {
            return InteractionResult.PASS;
        }
        if (ctx.m_43725_().f_46443_) {
            return InteractionResult.PASS;
        }
        ItemStack stack = ctx.m_43722_();
        Player player = ctx.m_43723_();
        Direction dir = player == null ? Direction.NORTH : Direction.m_122364_((double)ctx.m_43723_().m_146908_());
        boolean flag = TentItem.placeAt((LevelAccessor)ctx.m_43725_(), ctx.m_8083_().m_7494_(), dir, false, false);
        if (flag) {
            BlockEntity tile = ctx.m_43725_().m_7702_(ctx.m_8083_().m_7494_());
            if (tile instanceof TentBlockEntity && this.spawner) {
                ((TentBlockEntity)tile).setSpawn(true);
            }
            if (player == null || !player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        }
        return flag ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }
}

