/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModRecipes;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AlchemyTableMenu
extends AbstractContainerMenu {
    @NotNull
    private final Container alchemyTable;
    @NotNull
    private final ContainerData alchemyTableData;
    @NotNull
    private final Slot ingredientSlot;

    public AlchemyTableMenu(int containerId, @NotNull Inventory playerInventory) {
        this(containerId, playerInventory.f_35978_.m_9236_(), playerInventory, (Container)new SimpleContainer(6), (ContainerData)new SimpleContainerData(3));
    }

    public AlchemyTableMenu(int containerId, Level level, @NotNull Inventory playerInventory, @NotNull Container inventory, @NotNull ContainerData data) {
        super((MenuType)ModContainer.ALCHEMICAL_TABLE.get(), containerId);
        AlchemyTableMenu.m_38869_((Container)inventory, (int)5);
        AlchemyTableMenu.m_38886_((ContainerData)data, (int)3);
        this.alchemyTable = inventory;
        this.alchemyTableData = data;
        this.m_38897_(new OilSlot(level, inventory, 0, 55, 16));
        this.m_38897_(new OilSlot(level, inventory, 1, 79, 16));
        this.m_38897_(new ResultSlot(inventory, 2, 112, 72));
        this.m_38897_(new ResultSlot(inventory, 3, 140, 44));
        this.ingredientSlot = this.m_38897_(new IngredientSlot(level, inventory, 4, 15, 25));
        this.m_38897_(new FuelSlot(inventory, 5, 34, 69));
        this.m_38884_(data);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 101 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 159));
        }
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.alchemyTable.m_6542_(player);
    }

    public int getFuel() {
        return this.alchemyTableData.m_6413_(1);
    }

    public int getBrewingTicks() {
        return this.alchemyTableData.m_6413_(0);
    }

    public int getColor() {
        return this.alchemyTableData.m_6413_(2);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int slotId) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotId);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotId < 0 || slotId > 5) {
                if (FuelSlot.mayPlaceItem(itemstack) ? this.m_38903_(itemstack1, 5, 6, false) || this.ingredientSlot.m_5857_(itemstack1) && !this.m_38903_(itemstack1, 4, 5, false) : (this.ingredientSlot.m_5857_(itemstack1) ? !this.m_38903_(itemstack1, 4, 5, false) : (OilSlot.mayPlaceItem(player.m_9236_(), itemstack) && itemstack.m_41613_() == 1 ? !this.m_38903_(itemstack1, 0, 2, false) : (slotId >= 6 && slotId < 33 ? !this.m_38903_(itemstack1, 33, 42, false) : (slotId >= 33 && slotId < 42 ? !this.m_38903_(itemstack1, 6, 33, false) : !this.m_38903_(itemstack1, 6, 42, false)))))) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (!this.m_38903_(itemstack1, 6, 42, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    static class OilSlot
    extends Slot {
        private final Level world;

        public OilSlot(Level worldPos, @NotNull Container inventory, int slotId, int xPos, int yPos) {
            super(inventory, slotId, xPos, yPos);
            this.world = worldPos;
        }

        public static boolean mayPlaceItem(@NotNull Level world, @NotNull ItemStack itemstack) {
            return world.m_7465_().m_44013_((RecipeType)ModRecipes.ALCHEMICAL_TABLE_TYPE.get()).stream().anyMatch(recipe -> recipe.isIngredient(itemstack));
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return OilSlot.mayPlaceItem(this.world, stack);
        }

        public int m_6641_() {
            return 1;
        }
    }

    static class ResultSlot
    extends Slot {
        public ResultSlot(@NotNull Container inventory, int slotId, int xPos, int yPos) {
            super(inventory, slotId, xPos, yPos);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return false;
        }
    }

    static class IngredientSlot
    extends Slot {
        private final Level world;

        public IngredientSlot(Level worldPos, @NotNull Container inventory, int slotId, int xPos, int yPos) {
            super(inventory, slotId, xPos, yPos);
            this.world = worldPos;
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return this.world.m_7465_().m_44013_((RecipeType)ModRecipes.ALCHEMICAL_TABLE_TYPE.get()).stream().anyMatch(recipe -> recipe.isInput(stack));
        }

        public int m_6641_() {
            return 64;
        }
    }

    static class FuelSlot
    extends Slot {
        public FuelSlot(@NotNull Container inventory, int slotId, int xPos, int yPos) {
            super(inventory, slotId, xPos, yPos);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return FuelSlot.mayPlaceItem(stack);
        }

        public static boolean mayPlaceItem(@NotNull ItemStack stack) {
            return stack.m_41720_() == Items.f_42593_;
        }

        public int m_6641_() {
            return 64;
        }
    }
}

