/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.fluids;

import de.teamlapen.vampirism.blocks.BloodContainerBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BloodHelper {
    private static final Logger LOGGER = LogManager.getLogger(BloodHelper.class);

    public static boolean canStoreBlood(@NotNull ItemStack stack) {
        return BloodHelper.fill(stack, 1000, IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    @NotNull
    public static ItemStack getGlassBottleInHotbar(@NotNull Inventory inventory) {
        int hotbarSize = Inventory.m_36059_();
        for (int i = 0; i < hotbarSize; ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41619_() || !itemStack.m_41720_().equals(Items.f_42590_)) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public static int getBlood(@NotNull ItemStack stack) {
        return FluidUtil.getFluidContained((ItemStack)stack).map(FluidStack::getAmount).orElse(0);
    }

    public static int getBlood(@NotNull IFluidHandler cap) {
        FluidStack stack = cap.drain(new FluidStack((Fluid)ModFluids.BLOOD.get(), Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE);
        return stack.getAmount();
    }

    public static int getBlood(@NotNull LazyOptional<IFluidHandler> opt) {
        return opt.map(handler -> {
            FluidStack stack = handler.drain(new FluidStack((Fluid)ModFluids.BLOOD.get(), Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE);
            return stack.getAmount();
        }).orElse(0);
    }

    public static int drain(@NotNull ItemStack stack, int amount, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull IFluidHandler.FluidAction action, boolean exact, @NotNull Consumer<ItemStack> updateContainer) {
        if (exact && action.execute() && BloodHelper.drain(stack, amount, IFluidHandler.FluidAction.SIMULATE, false, updateContainer) != amount) {
            return 0;
        }
        return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> {
            FluidStack fluidStack = handler.drain(amount, action);
            updateContainer.accept(handler.getContainer());
            return fluidStack.getAmount();
        }).orElse(0);
    }

    public static int fill(@NotNull ItemStack stack, int amount, IFluidHandler.FluidAction action) {
        return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> handler.fill(new FluidStack((Fluid)ModFluids.BLOOD.get(), amount), action)).orElse(0);
    }

    public static int fillBloodIntoInventory(@NotNull Player player, int amt) {
        ItemStack container;
        ItemStack glass;
        if (amt <= 0) {
            return 0;
        }
        ItemStack stack = ItemStack.f_41583_;
        int hotbarSize = Inventory.m_36059_();
        for (int i = 0; i < hotbarSize; ++i) {
            ItemStack stack1 = player.m_150109_().m_8020_(i);
            if (stack1.m_41619_() || BloodHelper.fill(stack1, amt, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
            stack = stack1;
            break;
        }
        if (!stack.m_41619_()) {
            int filled = BloodHelper.fill(stack, amt, IFluidHandler.FluidAction.EXECUTE);
            if (filled > 0) {
                if (filled < amt) {
                    return BloodHelper.fillBloodIntoInventory(player, amt - filled);
                }
                return 0;
            }
            LOGGER.warn("Could not execute bottle fill even though simulation was successful. Item: {} Amount: {}", (Object)stack, (Object)amt);
        }
        if (!(glass = BloodHelper.getGlassBottleInHotbar(player.m_150109_())).m_41619_() && ((Boolean)VampirismConfig.COMMON.autoConvertGlassBottles.get()).booleanValue()) {
            ItemStack bloodBottle = new ItemStack((ItemLike)ModItems.BLOOD_BOTTLE.get(), 1);
            int filled = BloodHelper.fill(bloodBottle, amt, IFluidHandler.FluidAction.EXECUTE);
            if (filled == 0) {
                LOGGER.warn("Failed to fill blood bottle with blood");
            }
            glass.m_41774_(1);
            if (glass.m_41619_()) {
                player.m_150109_().m_36057_(glass);
            }
            if (!player.m_150109_().m_36054_(bloodBottle)) {
                player.m_36176_(bloodBottle, false);
            }
            return BloodHelper.fillBloodIntoInventory(player, amt - filled);
        }
        if (BloodHelper.hasFeedingAdapterInHotbar(player.m_150109_()) && !(container = BloodHelper.getBloodContainerInInventory(player.m_150109_(), false, true)).m_41619_()) {
            FluidStack content = BloodContainerBlock.getFluidFromItemStack(container);
            int filled = Math.min(amt, 12600 - content.getAmount());
            content.setAmount(content.getAmount() + filled);
            BloodContainerBlock.writeFluidToItemStack(container, content);
            return BloodHelper.fillBloodIntoInventory(player, amt - filled);
        }
        return amt;
    }

    public static boolean hasFeedingAdapterInHotbar(@NotNull Inventory inventory) {
        int hotbarSize = Inventory.m_36059_();
        for (int i = 0; i < hotbarSize; ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41619_() || !itemStack.m_41720_().equals(ModItems.FEEDING_ADAPTER.get())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static ItemStack getBloodContainerInInventory(@NotNull Inventory inventory, boolean allowFull, boolean allowEmpty) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            FluidStack content = BloodContainerBlock.getFluidFromItemStack(stack);
            if (content.getRawFluid() != ModFluids.BLOOD.get() || !allowFull && content.getAmount() >= 12600 || !allowEmpty && content.getAmount() <= 0) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }
}

