/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.tasks;

import com.google.common.base.Objects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.player.tasks.reward.ItemReward;
import de.teamlapen.vampirism.entity.player.tasks.reward.LordLevelReward;
import de.teamlapen.vampirism.util.CodecUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskInstance
implements ITaskInstance {
    public static final Codec<TaskInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CodecUtil.UUID.fieldOf("taskGiver").forGetter(t -> t.taskGiver), (App)ResourceKey.m_195966_(VampirismRegistries.TASK_ID).fieldOf("task").forGetter(t -> t.task), (App)CodecUtil.UUID.fieldOf("instanceId").forGetter(t -> t.instanceId), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)Codec.INT).fieldOf("stats").forGetter(t -> t.stats), (App)ITaskRewardInstance.CODEC.fieldOf("reward").forGetter(t -> t.reward), (App)Codec.LONG.fieldOf("taskDuration").forGetter(t -> t.taskDuration), (App)Codec.BOOL.fieldOf("accepted").forGetter(t -> t.accepted), (App)Codec.LONG.fieldOf("taskTimer").forGetter(t -> t.taskTimeStamp)).apply((Applicative)inst, TaskInstance::new));
    @NotNull
    private final UUID taskGiver;
    @NotNull
    private final ResourceKey<Task> task;
    @NotNull
    private final UUID instanceId;
    @NotNull
    private final Map<ResourceLocation, Integer> stats;
    @NotNull
    private final ITaskRewardInstance reward;
    private final long taskDuration;
    private boolean accepted;
    private long taskTimeStamp;
    private boolean completed;

    @Deprecated
    @NotNull
    public static TaskInstance readLegacy(@NotNull CompoundTag nbt) {
        ResourceKey task = ResourceKey.m_135785_(VampirismRegistries.TASK_ID, (ResourceLocation)new ResourceLocation(nbt.m_128461_("task")));
        UUID id = nbt.m_128342_("id");
        UUID insId = nbt.m_128342_("insId");
        boolean accepted = nbt.m_128471_("accepted");
        long taskTimer = nbt.m_128454_("taskTimer");
        CompoundTag statsNBT = nbt.m_128469_("stats");
        HashMap<ResourceLocation, Integer> stats = new HashMap<ResourceLocation, Integer>();
        statsNBT.m_128431_().forEach(name -> stats.put(new ResourceLocation(name), statsNBT.m_128451_(name)));
        ResourceLocation rewardId = new ResourceLocation(nbt.m_128461_("rewardId"));
        ITaskRewardInstance reward = TaskInstance.createReward(rewardId, nbt);
        long taskDuration = nbt.m_128454_("taskDuration");
        return new TaskInstance(id, (ResourceKey<Task>)task, insId, stats, reward, taskDuration, accepted, taskTimer);
    }

    private static ITaskRewardInstance createReward(ResourceLocation id, CompoundTag tag) {
        return switch (id.toString()) {
            case "vampirism:item" -> new ItemReward.Instance(ItemStack.m_41712_((CompoundTag)tag.m_128469_("reward")));
            case "vampirism:lord_level_reward" -> new LordLevelReward(tag.m_128451_("targetLevel"));
            default -> throw new IllegalArgumentException("Unknown reward id " + String.valueOf(id));
        };
    }

    public TaskInstance(@NotNull Holder.Reference<Task> task, @NotNull UUID taskGiver, @NotNull IFactionPlayer<?> player, long taskDuration) {
        this.task = task.m_205785_();
        this.taskGiver = taskGiver;
        this.instanceId = UUID.randomUUID();
        this.stats = new HashMap<ResourceLocation, Integer>();
        this.taskTimeStamp = -1L;
        this.taskDuration = taskDuration;
        this.reward = ((Task)task.m_203334_()).getReward().createInstance(player);
    }

    private TaskInstance(@NotNull UUID taskGiver, @NotNull ResourceKey<Task> task, @NotNull UUID instanceId, @NotNull Map<ResourceLocation, Integer> stats, @NotNull ITaskRewardInstance taskRewardInstance, long taskDuration, boolean accepted, long taskTimeStamp) {
        this.taskGiver = taskGiver;
        this.task = task;
        this.stats = new HashMap<ResourceLocation, Integer>(stats);
        this.accepted = accepted;
        this.taskTimeStamp = taskTimeStamp;
        this.instanceId = instanceId;
        this.reward = taskRewardInstance;
        this.taskDuration = taskDuration;
    }

    @Override
    public void aboardTask() {
        this.accepted = false;
        this.stats.clear();
        this.taskTimeStamp = -1L;
    }

    @Override
    public void complete() {
        this.completed = true;
    }

    @Override
    public void encode(@NotNull FriendlyByteBuf buffer) {
        buffer.m_272073_(CODEC, (Object)this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskInstance instance = (TaskInstance)o;
        return this.accepted == instance.accepted && this.taskTimeStamp == instance.taskTimeStamp && Objects.equal((Object)this.taskGiver, (Object)instance.taskGiver) && Objects.equal((Object)this.instanceId, (Object)instance.instanceId) && Objects.equal(this.task, instance.task) && Objects.equal(this.stats, instance.stats);
    }

    @Override
    @NotNull
    public UUID getId() {
        return this.instanceId;
    }

    @Override
    @NotNull
    public ITaskRewardInstance getReward() {
        return this.reward;
    }

    @Override
    @NotNull
    public Map<ResourceLocation, Integer> getStats() {
        return this.stats;
    }

    @Override
    @NotNull
    public ResourceKey<Task> getTask() {
        return this.task;
    }

    @Override
    @NotNull
    public UUID getTaskBoard() {
        return this.taskGiver;
    }

    @Override
    public long getTaskDuration() {
        return this.taskDuration;
    }

    @Override
    public long getTaskTimeStamp() {
        return this.taskTimeStamp;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.taskGiver, this.task, this.instanceId});
    }

    @Override
    public boolean isAccepted() {
        return this.accepted;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public boolean isUnique(Registry<Task> registry) {
        return registry.m_203636_(this.task).map(s -> s.m_203656_(ModTags.Tasks.IS_UNIQUE)).orElse(false);
    }

    @Override
    public void startTask(long timestamp) {
        this.taskTimeStamp = timestamp;
        this.accepted = true;
    }

    @Override
    @NotNull
    public CompoundTag writeNBT(@NotNull CompoundTag nbt) {
        DataResult result = CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this);
        nbt.m_128365_("instance", (Tag)result.getOrThrow(false, message -> LogManager.getLogger().error(message)));
        return nbt;
    }
}

