/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.skills;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillType;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillNode;
import de.teamlapen.vampirism.entity.player.skills.SkillTreeManager;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkillHandler<T extends IFactionPlayer<T>>
implements ISkillHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger(SkillHandler.class);
    private final ArrayList<ISkill<T>> enabledSkills = new ArrayList();
    private final T player;
    private final IPlayableFaction<T> faction;
    private final NonNullList<ItemStack> refinementItems = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private final Set<IRefinement> activeRefinements = new HashSet<IRefinement>();
    private final Map<IRefinement, AttributeModifier> refinementModifier = new HashMap<IRefinement, AttributeModifier>();
    private int maxSkillpoints;
    private boolean dirty = false;

    public SkillHandler(T player, IPlayableFaction<T> faction) {
        this.player = player;
        this.faction = faction;
    }

    @NotNull
    public Optional<SkillNode> anyLastNode() {
        ArrayDeque<SkillNode> queue = new ArrayDeque<SkillNode>();
        for (ISkillType skillType : VampirismAPI.skillManager().getSkillTypes()) {
            if (!skillType.isForFaction(this.faction)) continue;
            queue.add(this.getRootNode(skillType));
        }
        SkillNode skillNode = (SkillNode)queue.poll();
        while (skillNode != null) {
            List<SkillNode> child = skillNode.getChildren().stream().filter(this::isNodeEnabled).toList();
            if (!child.isEmpty()) {
                queue.addAll(child);
            } else if (skillNode.getParent() != null) {
                return Optional.of(skillNode);
            }
            skillNode = (SkillNode)queue.poll();
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public ISkillHandler.Result canSkillBeEnabled(@NotNull ISkill<T> skill) {
        if (this.player.getRepresentingPlayer().m_21124_((MobEffect)ModEffects.OBLIVION.get()) != null) {
            return ISkillHandler.Result.LOCKED_BY_PLAYER_STATE;
        }
        if (this.isSkillEnabled(skill)) {
            return ISkillHandler.Result.ALREADY_ENABLED;
        }
        SkillNode node = this.findSkillNode(this.getRootNode(skill.getType()), skill);
        if (node != null) {
            if (this.isSkillNodeLocked(node)) {
                return ISkillHandler.Result.LOCKED_BY_OTHER_NODE;
            }
            if (node.isRoot() || this.isNodeEnabled(node.getParent())) {
                if (this.getLeftSkillPoints() >= skill.getSkillPointCost()) {
                    return this.isNodeEnabled(node) ? ISkillHandler.Result.OTHER_NODE_SKILL : ISkillHandler.Result.OK;
                }
                return ISkillHandler.Result.NO_POINTS;
            }
            return ISkillHandler.Result.PARENT_NOT_ENABLED;
        }
        LOGGER.warn("Node for skill {} could not be found", skill);
        return ISkillHandler.Result.NOT_FOUND;
    }

    @Override
    public ItemStack @NotNull [] createRefinementItems() {
        return (ItemStack[])this.refinementItems.toArray(ItemStack[]::new);
    }

    @Override
    public NonNullList<ItemStack> getRefinementItems() {
        return this.refinementItems;
    }

    @Override
    public void damageRefinements() {
        this.refinementItems.stream().filter(s -> !s.m_41619_()).forEach(stack -> {
            IRefinementSet set = ((IRefinementItem)stack.m_41720_()).getRefinementSet((ItemStack)stack);
            int damage = 40 + (set.getRarity().weight - 1) * 10 + this.getPlayer().getRepresentingPlayer().m_217043_().m_188503_(60);
            Integer unbreakingLevel = (Integer)EnchantmentHelper.m_44831_((ItemStack)stack).get(Enchantments.f_44986_);
            if (unbreakingLevel != null) {
                damage = (int)((float)damage / (1.0f / (1.6f / ((float)unbreakingLevel.intValue() + 1.0f))));
            }
            stack.m_41721_(stack.m_41773_() + damage);
            if (stack.m_41773_() >= stack.m_41776_()) {
                stack.m_41764_(0);
            }
        });
    }

    public void disableAllSkills() {
        for (ISkill<T> skill : this.enabledSkills) {
            skill.onDisable(this.player);
        }
        this.enabledSkills.clear();
        this.dirty = true;
    }

    @Override
    public void disableSkill(@NotNull ISkill<T> skill) {
        if (this.enabledSkills.remove(skill)) {
            skill.onDisable(this.player);
            this.dirty = true;
        }
    }

    @Override
    public void enableRootSkills() {
        FactionPlayerHandler.getOpt(this.player.getRepresentingPlayer()).ifPresent(handler -> {
            for (ISkillType skillType : VampirismAPI.skillManager().getSkillTypes()) {
                if (!skillType.isForFaction(this.faction) || !skillType.isUnlocked((IFactionPlayerHandler)handler)) continue;
                this.enableRootSkill(skillType);
            }
        });
    }

    @Override
    public void enableRootSkill(@NotNull ISkillType type) {
        this.enableSkill(this.getRootNode(type).getElements()[0]);
    }

    @Override
    public void enableSkill(@NotNull ISkill<T> skill) {
        if (!this.enabledSkills.contains(skill)) {
            skill.onEnable(this.player);
            this.enabledSkills.add(skill);
            this.dirty = true;
            Player player = this.player.getRepresentingPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (serverPlayer.f_8906_ != null) {
                    serverPlayer.m_36220_(ModStats.skills_unlocked);
                    ModAdvancements.TRIGGER_SKILL_UNLOCKED.trigger(serverPlayer, skill);
                }
            }
        }
    }

    @Override
    public boolean equipRefinementItem(@NotNull ItemStack stack) {
        IRefinementItem refinementItem;
        Item item = stack.m_41720_();
        if (item instanceof IRefinementItem && this.faction.equals((refinementItem = (IRefinementItem)item).getExclusiveFaction(stack))) {
            @Nullable IRefinementSet newSet = refinementItem.getRefinementSet(stack);
            IRefinementItem.AccessorySlotType setSlot = refinementItem.getSlotType();
            this.removeRefinementItem(setSlot);
            this.dirty = true;
            this.applyRefinementItem(stack, setSlot.getSlot());
            return true;
        }
        return false;
    }

    @Override
    public void removeRefinementItem(@NotNull IRefinementItem.AccessorySlotType slot) {
        this.removeRefinementItem(slot.getSlot());
        this.dirty = true;
    }

    @Nullable
    public SkillNode findSkillNode(@NotNull SkillNode base, ISkill<T> skill) {
        for (ISkill<?> s : base.getElements()) {
            if (!s.equals(skill)) continue;
            return base;
        }
        for (SkillNode child : base.getChildren()) {
            SkillNode node = this.findSkillNode(child, skill);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getLeftSkillPoints() {
        int remainingSkillPoints = this.maxSkillpoints - this.enabledSkills.stream().mapToInt(ISkill::getSkillPointCost).sum();
        if (((Boolean)VampirismConfig.SERVER.unlockAllSkills.get()).booleanValue() && FactionPlayerHandler.getOpt(this.player.getRepresentingPlayer()).filter(s -> s.getCurrentLevel() == s.getCurrentFaction().getHighestReachableLevel()).filter(s -> s.getCurrentFaction().getHighestLordLevel() == 0 || s.getLordLevel() == s.getCurrentFaction().getHighestLordLevel()).isPresent()) {
            return Integer.MAX_VALUE;
        }
        return remainingSkillPoints;
    }

    @Override
    public int getMaxSkillPoints() {
        return this.maxSkillpoints;
    }

    @Override
    public void addSkillPoints(int points) {
        this.maxSkillpoints = Math.max(0, this.maxSkillpoints + points);
        this.dirty = true;
    }

    @Override
    public void reset() {
        this.disableAllSkills();
        this.resetRefinements();
        this.maxSkillpoints = 0;
        this.dirty = true;
    }

    @NotNull
    public List<ISkill<T>> getLockingSkills(@NotNull SkillNode nodeIn) {
        return Arrays.stream(nodeIn.getLockingNodes()).map(id -> SkillTreeManager.getInstance().getSkillTree().getNodeFromId((ResourceLocation)id)).filter(Objects::nonNull).flatMap(node -> Arrays.stream(node.getElements())).collect(Collectors.toList());
    }

    @Override
    public ISkill<T> @Nullable [] getParentSkills(@NotNull ISkill<T> skill) {
        SkillNode node = this.findSkillNode(this.getRootNode(skill.getType()), skill);
        if (node == null) {
            return null;
        }
        return node.getParent().getElements();
    }

    public T getPlayer() {
        return this.player;
    }

    @NotNull
    public Collection<SkillNode> getRootNodes() {
        return VampirismAPI.skillManager().getSkillTypes().stream().map(this::getRootNode).collect(Collectors.toList());
    }

    @NotNull
    public SkillNode getRootNode(@NotNull ISkillType type) {
        return VampirismMod.proxy.getSkillTree(this.player.isRemote()).getRootNodeForFaction(type.createIdForFaction(this.faction.getID()));
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isNodeEnabled(@NotNull SkillNode node) {
        for (ISkill<T> s : this.enabledSkills) {
            if (!node.containsSkill(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRefinementEquipped(IRefinement refinement) {
        return this.activeRefinements.contains(refinement);
    }

    @Override
    public boolean isSkillEnabled(ISkill<?> skill) {
        return this.enabledSkills.contains(skill);
    }

    public boolean isSkillNodeLocked(@NotNull SkillNode nodeIn) {
        return Arrays.stream(nodeIn.getLockingNodes()).map(id -> SkillTreeManager.getInstance().getSkillTree().getNodeFromId((ResourceLocation)id)).filter(Objects::nonNull).flatMap(node -> Arrays.stream(node.getElements())).anyMatch(this::isSkillEnabled);
    }

    public void loadFromNbt(@NotNull CompoundTag nbt) {
        if (nbt.m_128441_("skills")) {
            for (Object id : nbt.m_128469_("skills").m_128431_()) {
                ISkill<?> skill = RegUtil.getSkill(new ResourceLocation((String)id));
                if (skill == null) {
                    LOGGER.warn("Skill {} does not exist anymore", id);
                    continue;
                }
                this.enableSkill(skill);
            }
        }
        if (nbt.m_128441_("refinement_set")) {
            CompoundTag setsNBT = nbt.m_128469_("refinement_set");
            for (String id : setsNBT.m_128431_()) {
                int i = Integer.parseInt(id);
                CompoundTag setNBT = setsNBT.m_128469_(id);
                String setName = setNBT.m_128461_("id");
                int damage = setNBT.m_128451_("damage");
                if ("none".equals(setName)) continue;
                ResourceLocation setId = new ResourceLocation(setName);
                IRefinementSet set = RegUtil.getRefinementSet(setId);
                Object refinementItem = this.faction.getRefinementItem(IRefinementItem.AccessorySlotType.values()[i]);
                ItemStack itemStack = new ItemStack(refinementItem);
                itemStack.m_41721_(damage);
                ((IRefinementItem)refinementItem).applyRefinementSet(itemStack, set);
                this.applyRefinementItem(itemStack, i);
            }
        }
        if (nbt.m_128441_("refinement_items")) {
            ListTag refinements = nbt.m_128437_("refinement_items", 10);
            for (int i = 0; i < refinements.size(); ++i) {
                IRefinementItem refinementItem;
                IFaction<?> exclusiveFaction;
                CompoundTag stackNbt = refinements.m_128728_(i);
                int slot = stackNbt.m_128451_("slot");
                ItemStack stack = ItemStack.m_41712_((CompoundTag)stackNbt);
                Item damage = stack.m_41720_();
                if (!(damage instanceof IRefinementItem) || (exclusiveFaction = (refinementItem = (IRefinementItem)damage).getExclusiveFaction(stack)) != null && !this.faction.equals(exclusiveFaction)) continue;
                this.applyRefinementItem(stack, slot);
            }
        }
        if (nbt.m_128441_("skill_points")) {
            this.maxSkillpoints = nbt.m_128451_("skill_points");
        }
    }

    public void readUpdateFromServer(@NotNull CompoundTag nbt) {
        if (nbt.m_128441_("skills")) {
            List old = (List)this.enabledSkills.clone();
            for (String id : nbt.m_128469_("skills").m_128431_()) {
                ISkill<?> skill = RegUtil.getSkill(new ResourceLocation(id));
                if (skill == null) {
                    LOGGER.error("Skill {} does not exist on client!!!", (Object)id);
                    continue;
                }
                if (old.contains(skill)) {
                    old.remove(skill);
                    continue;
                }
                this.enableSkill(skill);
            }
            for (ISkill skill : old) {
                this.disableSkill(skill);
            }
        }
        if (nbt.m_128441_("refinement_items")) {
            ListTag refinements = nbt.m_128437_("refinement_items", 10);
            for (int i = 0; i < refinements.size(); ++i) {
                IRefinementItem refinementItem;
                IFaction<?> exclusiveFaction;
                CompoundTag stackNbt = refinements.m_128728_(i);
                int slot = stackNbt.m_128451_("slot");
                ItemStack stack = ItemStack.m_41712_((CompoundTag)stackNbt);
                Item item = stack.m_41720_();
                if (!(item instanceof IRefinementItem) || (exclusiveFaction = (refinementItem = (IRefinementItem)item).getExclusiveFaction(stack)) != null && !this.faction.equals(exclusiveFaction)) continue;
                this.applyRefinementItem(stack, slot);
            }
        }
        if (nbt.m_128441_("skill_points")) {
            this.maxSkillpoints = nbt.m_128451_("skill_points");
        }
    }

    @Override
    public void resetRefinements() {
        this.refinementItems.clear();
    }

    @Override
    public void resetSkills() {
        this.disableAllSkills();
        this.enableRootSkills();
    }

    public void saveToNbt(@NotNull CompoundTag nbt) {
        CompoundTag skills = new CompoundTag();
        for (ISkill<T> skill : this.enabledSkills) {
            skills.m_128379_(RegUtil.id(skill).toString(), true);
        }
        nbt.m_128365_("skills", (Tag)skills);
        ListTag refinements = new ListTag();
        for (int i = 0; i < this.refinementItems.size(); ++i) {
            ItemStack stack = (ItemStack)this.refinementItems.get(i);
            if (stack.m_41619_()) continue;
            CompoundTag stackNbt = new CompoundTag();
            stackNbt.m_128405_("slot", i);
            stack.m_41739_(stackNbt);
            refinements.add((Object)stackNbt);
        }
        nbt.m_128365_("refinement_items", (Tag)refinements);
        nbt.m_128405_("skill_points", this.maxSkillpoints);
    }

    public void writeUpdateForClient(@NotNull CompoundTag nbt) {
        CompoundTag skills = new CompoundTag();
        for (ISkill<T> skill : this.enabledSkills) {
            skills.m_128379_(RegUtil.id(skill).toString(), true);
        }
        nbt.m_128365_("skills", (Tag)skills);
        ListTag refinementItems = new ListTag();
        for (int i = 0; i < this.refinementItems.size(); ++i) {
            ItemStack stack = (ItemStack)this.refinementItems.get(i);
            if (stack.m_41619_()) continue;
            CompoundTag stackNbt = new CompoundTag();
            stackNbt.m_128405_("slot", i);
            stack.m_41739_(stackNbt);
            refinementItems.add((Object)stackNbt);
        }
        nbt.m_128365_("refinement_items", (Tag)refinementItems);
        nbt.m_128405_("skill_points", this.maxSkillpoints);
        this.dirty = false;
    }

    private void applyRefinementItem(@NotNull ItemStack stack, int slot) {
        IRefinementItem refinementItem;
        IRefinementSet set;
        this.refinementItems.set(slot, (Object)stack);
        Item item = stack.m_41720_();
        if (item instanceof IRefinementItem && (set = (refinementItem = (IRefinementItem)item).getRefinementSet(stack)) != null) {
            set.getRefinements().stream().map(RegistryObject::get).forEach(x -> {
                this.activeRefinements.add((IRefinement)x);
                if (!this.player.isRemote() && x.getAttribute() != null) {
                    AttributeInstance attributeInstance = this.player.getRepresentingPlayer().m_21051_(x.getAttribute());
                    double value = x.getModifierValue();
                    AttributeModifier t = attributeInstance.m_22111_(x.getUUID());
                    if (t != null) {
                        attributeInstance.m_22130_(t);
                        value += t.m_22218_();
                    }
                    t = x.createAttributeModifier(x.getUUID(), value);
                    this.refinementModifier.put((IRefinement)x, t);
                    attributeInstance.m_22118_(t);
                }
            });
        }
    }

    private void removeRefinementItem(int slot) {
        ItemStack stack = (ItemStack)this.refinementItems.get(slot);
        if (!stack.m_41619_()) {
            IRefinementItem refinementItem;
            IRefinementSet set;
            this.refinementItems.set(slot, (Object)ItemStack.f_41583_);
            Item item = stack.m_41720_();
            if (item instanceof IRefinementItem && (set = (refinementItem = (IRefinementItem)item).getRefinementSet(stack)) != null) {
                set.getRefinements().stream().map(RegistryObject::get).forEach(x -> {
                    this.activeRefinements.remove(x);
                    if (!this.player.isRemote() && x.getAttribute() != null) {
                        AttributeInstance attributeInstance = this.player.getRepresentingPlayer().m_21051_(x.getAttribute());
                        AttributeModifier t = this.refinementModifier.remove(x);
                        attributeInstance.m_22130_(t);
                        double value = t.m_22218_() - x.getModifierValue();
                        if (value != 0.0) {
                            t = x.createAttributeModifier(t.m_22209_(), value);
                            attributeInstance.m_22118_(t);
                            this.refinementModifier.put((IRefinement)x, t);
                            this.activeRefinements.add((IRefinement)x);
                        }
                    }
                });
            }
        }
    }
}

