/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.refinements;

import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Refinement
implements IRefinement {
    @Nullable
    private final Attribute attribute;
    @Nullable
    private final BiFunction<UUID, Double, AttributeModifier> modifier;
    @Nullable
    private final UUID uuid;
    private final double baseValue;
    private boolean detrimental = false;
    private MutableComponent description;

    public Refinement(Attribute attribute, UUID uuid, double baseValue, BiFunction<UUID, Double, AttributeModifier> modifier) {
        this.attribute = attribute;
        this.modifier = modifier;
        this.uuid = uuid;
        this.baseValue = baseValue;
    }

    public Refinement() {
        this.attribute = null;
        this.modifier = null;
        this.baseValue = 0.0;
        this.uuid = null;
    }

    @Override
    public AttributeModifier createAttributeModifier(UUID uuid, double value) {
        return this.modifier == null ? null : this.modifier.apply(uuid, value);
    }

    @Override
    @Nullable
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    @NotNull
    public Component getDescription() {
        if (this.description == null) {
            this.description = Component.m_237115_((String)("refinement." + RegUtil.id(this).m_135827_() + "." + RegUtil.id(this).m_135815_() + ".desc"));
            if (this.detrimental) {
                this.description.m_130940_(ChatFormatting.RED);
            }
        }
        return this.description;
    }

    @Override
    public double getModifierValue() {
        return this.baseValue;
    }

    @Override
    @Nullable
    public UUID getUUID() {
        return this.uuid;
    }

    @NotNull
    public Refinement setDetrimental() {
        this.detrimental = true;
        return this;
    }
}

