/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai.goals;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FleeGoal
extends Goal {
    private final PathfinderMob theCreature;
    private final double movementSpeed;
    @NotNull
    private final Level world;
    private final boolean restrictToHome;
    private double shelterX;
    private double shelterY;
    private double shelterZ;

    public FleeGoal(@NotNull PathfinderMob theCreature, double movementSpeed, boolean restrictToHome) {
        this.theCreature = theCreature;
        this.movementSpeed = movementSpeed;
        this.restrictToHome = restrictToHome;
        this.world = theCreature.m_20193_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.shouldFlee()) {
            return false;
        }
        Vec3 vec3 = this.findPossibleShelter();
        if (vec3 == null) {
            return false;
        }
        this.shelterX = vec3.f_82479_;
        this.shelterY = vec3.f_82480_;
        this.shelterZ = vec3.f_82481_;
        return true;
    }

    public boolean continueExecuting() {
        return !this.theCreature.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.theCreature.m_21573_().m_26519_(this.shelterX, this.shelterY, this.shelterZ, this.movementSpeed);
    }

    protected abstract boolean isPositionAcceptable(Level var1, BlockPos var2);

    protected abstract boolean shouldFlee();

    @Nullable
    private Vec3 findPossibleShelter() {
        RandomSource random = this.theCreature.m_217043_();
        BlockPos blockpos = new BlockPos((int)this.theCreature.m_20185_(), (int)this.theCreature.m_20191_().f_82289_, (int)this.theCreature.m_20189_());
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.m_7918_(random.m_188503_(20) - 10, random.m_188503_(6) - 3, random.m_188503_(20) - 10);
            if (!this.isPositionAcceptable(this.world, blockpos1) || this.restrictToHome && !this.theCreature.m_21534_().equals((Object)BlockPos.f_121853_) && !this.theCreature.m_21444_(blockpos1)) continue;
            return new Vec3((double)blockpos1.m_123341_(), (double)blockpos1.m_123342_(), (double)blockpos1.m_123343_());
        }
        return null;
    }
}

