/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai.goals;

import de.teamlapen.vampirism.entity.DarkBloodProjectileEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AttackRangedDarkBloodGoal
extends Goal {
    protected final VampireBaronEntity entity;
    private final int attackCooldown;
    private final int maxAttackDistance;
    private final float directDamage;
    private final float indirectDamage;
    private int attackTime;
    private int seeTime;

    public AttackRangedDarkBloodGoal(VampireBaronEntity entity, int cooldown, int maxDistance, float damage, float indirectDamage) {
        this.entity = entity;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.attackCooldown = cooldown;
        this.maxAttackDistance = maxDistance;
        this.directDamage = damage;
        this.indirectDamage = indirectDamage;
    }

    public boolean m_8036_() {
        return this.entity.m_5448_() != null;
    }

    public void m_8041_() {
        this.seeTime = 0;
        this.attackTime = 0;
    }

    public void m_8037_() {
        if (this.attackTime > 0) {
            --this.attackTime;
        } else {
            LivingEntity target = this.entity.m_5448_();
            if (target != null) {
                boolean couldSee;
                double d0 = this.entity.m_20275_(target.m_20185_(), target.m_20191_().f_82289_, target.m_20189_());
                boolean canSee = this.entity.m_21574_().m_148306_((Entity)target);
                boolean bl = couldSee = this.seeTime > 0;
                if (canSee != couldSee) {
                    this.seeTime = 0;
                }
                if (canSee) {
                    ++this.seeTime;
                    this.entity.m_21391_((Entity)target, 19.0f, 10.0f);
                    this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20299_(1.0f));
                } else {
                    --this.seeTime;
                }
                if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                    this.attack(target);
                    this.attackTime = this.attackCooldown;
                    this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20));
                } else {
                    this.entity.m_21573_().m_5624_((Entity)target, 1.0);
                }
            }
        }
    }

    protected void attack(@NotNull LivingEntity target) {
        Vec3 vec3d = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() * 0.6f), 0.0).m_82546_(this.entity.m_20299_(1.0f)).m_82541_();
        DarkBloodProjectileEntity projectile = new DarkBloodProjectileEntity(this.entity.m_20193_(), this.entity.m_20185_() + vec3d.f_82479_ * (double)0.3f, this.entity.m_20186_() + (double)(this.entity.m_20192_() * 0.9f), this.entity.m_20189_() + vec3d.f_82481_ * (double)0.3f, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
        projectile.m_5602_((Entity)this.entity);
        projectile.setDamage(this.directDamage, this.indirectDamage);
        if (this.entity.m_20280_((Entity)target) > 64.0) {
            projectile.setMotionFactor(0.95f);
        } else {
            projectile.setMotionFactor(0.75f);
        }
        projectile.setInitialNoClip();
        projectile.excludeShooter();
        this.entity.m_20193_().m_7967_((Entity)projectile);
    }
}

