/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.recipebuilder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.advancements.critereon.SkillUnlockedCriterionTrigger;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.mixin.ShapelessRecipeBuilderAccessor;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShapelessWeaponTableRecipeBuilder
extends ShapelessRecipeBuilder {
    private int lava = 1;
    private ISkill<?>[] skills;
    private int level = 1;

    @NotNull
    public static ShapelessWeaponTableRecipeBuilder shapelessWeaponTable(@NotNull RecipeCategory category, @NotNull ItemLike result, int count) {
        return new ShapelessWeaponTableRecipeBuilder(category, result, count);
    }

    @NotNull
    public static ShapelessWeaponTableRecipeBuilder shapelessWeaponTable(@NotNull RecipeCategory category, @NotNull ItemLike result) {
        return new ShapelessWeaponTableRecipeBuilder(category, result, 1);
    }

    public ShapelessWeaponTableRecipeBuilder(@NotNull RecipeCategory category, @NotNull ItemLike resultIn, int countIn) {
        super(category, resultIn, countIn);
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder group(@Nullable String groupIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.m_126145_(groupIn);
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder requires(@NotNull ItemLike itemIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.m_126209_(itemIn);
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder requires(@NotNull ItemLike itemIn, int quantity) {
        return (ShapelessWeaponTableRecipeBuilder)super.m_126211_(itemIn, quantity);
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder requires(@NotNull Ingredient ingredientIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.m_126184_(ingredientIn);
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder requires(@NotNull Ingredient ingredientIn, int quantity) {
        return (ShapelessWeaponTableRecipeBuilder)super.m_126186_(ingredientIn, quantity);
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder requires(@NotNull TagKey<Item> tagIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.m_206419_(tagIn);
    }

    public void m_126140_(@NotNull Consumer<FinishedRecipe> consumerIn, @NotNull ResourceLocation id) {
        id = new ResourceLocation(id.m_135827_(), "weapontable/" + id.m_135815_());
        this.f_126176_.m_138386_("has_skill", (CriterionTriggerInstance)SkillUnlockedCriterionTrigger.builder(this.skills != null && this.skills.length >= 1 ? this.skills[0] : (ISkill<?>)HunterSkills.WEAPON_TABLE.get()));
        this.m_126207_(id);
        this.f_126176_.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumerIn.accept((FinishedRecipe)new Result(id, this.f_126173_, this.f_126174_, this.f_126177_ == null ? "" : this.f_126177_, ShapelessWeaponTableRecipeBuilder.m_245179_((RecipeCategory)((ShapelessRecipeBuilderAccessor)((Object)this)).getRecipeCategory()), this.f_126175_, this.f_126176_, id.m_247449_("recipes/" + ((ShapelessRecipeBuilderAccessor)((Object)this)).getRecipeCategory().m_247710_() + "/" + id.m_135815_()), this.lava, this.skills != null ? this.skills : new ISkill[]{}, this.level));
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder lava(int amount) {
        this.lava = amount;
        return this;
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder level(int level) {
        this.level = level;
        return this;
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder unlockedBy(@NotNull String name, @NotNull CriterionTriggerInstance criterionIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.m_126132_(name, criterionIn);
    }

    @NotNull
    public ShapelessWeaponTableRecipeBuilder skills(ISkill<?> ... skills) {
        this.skills = skills;
        return this;
    }

    private static class Result
    extends ShapelessRecipeBuilder.Result {
        private final int lava;
        private final ISkill<?>[] skills;
        private final int level;

        public Result(@NotNull ResourceLocation idIn, @NotNull Item resultIn, int countIn, @NotNull String groupIn, @NotNull CraftingBookCategory category, @NotNull List<Ingredient> ingredientsIn, @NotNull Advancement.Builder advancementBuilderIn, @NotNull ResourceLocation advancementIdIn, int lavaIn, @NotNull ISkill<?>[] skillsIn, int levelIn) {
            super(idIn, resultIn, countIn, groupIn, category, ingredientsIn, advancementBuilderIn, advancementIdIn);
            this.lava = lavaIn;
            this.skills = skillsIn;
            this.level = levelIn;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.SHAPELESS_CRAFTING_WEAPONTABLE.get();
        }

        public void m_7917_(@NotNull JsonObject json) {
            super.m_7917_(json);
            json.addProperty("lava", (Number)this.lava);
            JsonArray skills = new JsonArray();
            for (ISkill<?> skill : this.skills) {
                skills.add(RegUtil.id(skill).toString());
            }
            json.add("skill", (JsonElement)skills);
            json.addProperty("level", (Number)this.level);
        }
    }
}

