/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.blocks.TotemTopBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.mixin.StructuresAccessor;
import de.teamlapen.vampirism.world.gen.VanillaStructureModifications;
import de.teamlapen.vampirism.world.gen.structure.crypt.CryptStructurePieces;
import de.teamlapen.vampirism.world.gen.structure.huntercamp.HunterCampPieces;
import de.teamlapen.vampirism.world.gen.structure.huntercamp.HunterCampStructure;
import de.teamlapen.vampirism.world.gen.structure.hunteroutpost.BadlandsHunterOutpostPools;
import de.teamlapen.vampirism.world.gen.structure.hunteroutpost.DesertHunterOutpostPools;
import de.teamlapen.vampirism.world.gen.structure.hunteroutpost.HunterOutpostPools;
import de.teamlapen.vampirism.world.gen.structure.hunteroutpost.PlainsHunterOutpostPools;
import de.teamlapen.vampirism.world.gen.structure.hunteroutpost.VampireForestHunterOutpostPools;
import de.teamlapen.vampirism.world.gen.structure.mother.MotherPiece;
import de.teamlapen.vampirism.world.gen.structure.mother.MotherStructure;
import de.teamlapen.vampirism.world.gen.structure.templatesystem.BiomeTopBlockProcessor;
import de.teamlapen.vampirism.world.gen.structure.templatesystem.RandomBlockStateRule;
import de.teamlapen.vampirism.world.gen.structure.templatesystem.RandomStructureProcessor;
import de.teamlapen.vampirism.world.gen.structure.vampirealtar.VampireAltarPieces;
import de.teamlapen.vampirism.world.gen.structure.vampirealtar.VampireAltarStructure;
import de.teamlapen.vampirism.world.gen.structure.vampirehut.VampireHutPieces;
import de.teamlapen.vampirism.world.gen.structure.vampirehut.VampireHutStructure;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ModStructures {
    public static final DeferredRegister<StructureType<?>> STRUCTURE_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256938_, (String)"vampirism");
    public static final DeferredRegister<StructurePieceType> STRUCTURE_PIECES = DeferredRegister.create((ResourceKey)Registries.f_256786_, (String)"vampirism");
    public static final DeferredRegister<StructureProcessorType<?>> STRUCTURE_PROCESSOR_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256983_, (String)"vampirism");
    public static final RegistryObject<StructureType<HunterCampStructure>> HUNTER_CAMP_TYPE = STRUCTURE_TYPES.register("hunter_camp", () -> () -> HunterCampStructure.CODEC);
    public static final RegistryObject<StructureType<VampireHutStructure>> VAMPIRE_HUT_TYPE = STRUCTURE_TYPES.register("vampire_hut", () -> () -> VampireHutStructure.CODEC);
    public static final RegistryObject<StructureType<VampireAltarStructure>> VAMPIRE_ALTAR_TYPE = STRUCTURE_TYPES.register("vampire_altar", () -> () -> VampireAltarStructure.CODEC);
    public static final RegistryObject<StructureType<MotherStructure>> MOTHER_TYPE = STRUCTURE_TYPES.register("mother", () -> () -> MotherStructure.CODEC);
    public static final RegistryObject<StructurePieceType> HUNTER_CAMP_FIREPLACE = STRUCTURE_PIECES.register("hunter_camp_fireplace", () -> HunterCampPieces.Fireplace::new);
    public static final RegistryObject<StructurePieceType> HUNTER_CAMP_TENT = STRUCTURE_PIECES.register("hunter_camp_tent", () -> HunterCampPieces.Tent::new);
    public static final RegistryObject<StructurePieceType> HUNTER_CAMP_SPECIAL = STRUCTURE_PIECES.register("hunter_camp_craftingtable", () -> HunterCampPieces.SpecialBlock::new);
    public static final RegistryObject<StructurePieceType> VAMPIRE_HUT_PIECE = STRUCTURE_PIECES.register("vampire_hut", () -> VampireHutPieces.VampireHutPiece::new);
    public static final RegistryObject<StructurePieceType> VAMPIRE_ALTAR_PIECE = STRUCTURE_PIECES.register("vampire_altar", () -> VampireAltarPieces.VampireAltarPiece::new);
    public static final RegistryObject<StructurePieceType> MOTHER_PIECE = STRUCTURE_PIECES.register("mother", () -> MotherPiece::new);
    public static final RegistryObject<StructureProcessorType<RandomStructureProcessor>> RANDOM_SELECTOR = STRUCTURE_PROCESSOR_TYPES.register("random_selector", () -> () -> RandomStructureProcessor.CODEC);
    public static final RegistryObject<StructureProcessorType<BiomeTopBlockProcessor>> BIOME_BASED = STRUCTURE_PROCESSOR_TYPES.register("biome_based", () -> () -> BiomeTopBlockProcessor.CODEC);
    public static final ResourceKey<Structure> HUNTER_CAMP = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("vampirism", "hunter_camp"));
    public static final ResourceKey<Structure> VAMPIRE_HUT = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("vampirism", "vampire_hut"));
    public static final ResourceKey<Structure> HUNTER_OUTPOST_PLAINS = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("vampirism", "hunter_outpost_plains"));
    public static final ResourceKey<Structure> HUNTER_OUTPOST_DESERT = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("vampirism", "hunter_outpost_desert"));
    public static final ResourceKey<Structure> HUNTER_OUTPOST_VAMPIRE_FOREST = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("vampirism", "hunter_outpost_vampire_forest"));
    public static final ResourceKey<Structure> HUNTER_OUTPOST_BADLANDS = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("vampirism", "hunter_outpost_badlands"));
    public static final ResourceKey<Structure> VAMPIRE_ALTAR = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("vampirism", "vampire_altar"));
    public static final ResourceKey<Structure> MOTHER = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("vampirism", "mother"));
    public static final ResourceKey<Structure> CRYPT = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("vampirism", "crypt"));
    public static final ResourceKey<StructureTemplatePool> HUNTER_TRAINER = ModStructures.createTemplatePool("village/entities/hunter_trainer");
    public static final ResourceKey<StructureProcessorList> TOTEM_FACTION = ModStructures.createProcessorList("totem_faction");
    public static final ResourceKey<StructureSet> HUNTER_CAMP_SET = ModStructures.createStructureSetKey("hunter_camp");
    public static final ResourceKey<StructureSet> VAMPIRE_HUT_SET = ModStructures.createStructureSetKey("vampire_hut");
    public static final ResourceKey<StructureSet> VAMPIRE_ALTAR_SET = ModStructures.createStructureSetKey("vampire_altar");
    public static final ResourceKey<StructureSet> HUNTER_OUTPOST = ModStructures.createStructureSetKey("hunter_outpost");
    public static final ResourceKey<StructureSet> MOTHER_SET = ModStructures.createStructureSetKey("mother");
    public static final ResourceKey<StructureSet> CRYPT_SET = ModStructures.createStructureSetKey("crypt");

    private static ResourceKey<StructureSet> createStructureSetKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256998_, (ResourceLocation)new ResourceLocation("vampirism", name));
    }

    public static ResourceKey<StructureTemplatePool> createTemplatePool(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation("vampirism", name));
    }

    private static ResourceKey<StructureProcessorList> createProcessorList(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("vampirism", name));
    }

    public static void register(IEventBus bus) {
        STRUCTURE_TYPES.register(bus);
        STRUCTURE_PIECES.register(bus);
        STRUCTURE_PROCESSOR_TYPES.register(bus);
    }

    public static void createStructurePoolTemplates(BootstapContext<StructureTemplatePool> context) {
        HolderGetter holderGetter = context.m_255420_(Registries.f_256948_);
        HolderGetter processorList = context.m_255420_(Registries.f_257011_);
        Holder.Reference empty = holderGetter.m_255043_(Pools.f_127186_);
        context.m_255272_(HUNTER_TRAINER, (Object)new StructureTemplatePool((Holder)empty, (List)Lists.newArrayList((Object[])new Pair[]{Pair.of(VanillaStructureModifications.singleJigsawPieceFunction((HolderGetter<StructureProcessorList>)processorList, "village/entities/hunter_trainer"), (Object)1)}), StructureTemplatePool.Projection.RIGID));
        CryptStructurePieces.bootstrap(context);
        HunterOutpostPools.bootstrap(context);
    }

    public static void createStructureProcessorLists(BootstapContext<StructureProcessorList> context) {
        RandomStructureProcessor factionProcessor = new RandomStructureProcessor((List<RandomBlockStateRule>)ImmutableList.of((Object)((Object)new RandomBlockStateRule((RuleTest)new RandomBlockMatchTest((Block)ModBlocks.TOTEM_TOP.get(), ((Double)VampirismConfig.COMMON.villageTotemFactionChance.getDefault()).floatValue()), (RuleTest)AlwaysTrueTest.f_73954_, ((TotemTopBlock)((Object)ModBlocks.TOTEM_TOP.get())).m_49966_(), TotemTopBlock.getBlocks().stream().filter(totemx -> totemx != ModBlocks.TOTEM_TOP.get() && !totemx.isCrafted()).map(Block::m_49966_).collect(Collectors.toList())))));
        BiomeTopBlockProcessor biomeTopBlockProcessor = new BiomeTopBlockProcessor(Blocks.f_50493_.m_49966_());
        context.m_255272_(TOTEM_FACTION, (Object)new StructureProcessorList((List)ImmutableList.of((Object)((Object)factionProcessor), (Object)((Object)biomeTopBlockProcessor))));
    }

    public static void createStructureSets(BootstapContext<StructureSet> context) {
        HolderGetter structureLookup = context.m_255420_(Registries.f_256944_);
        HolderGetter structureSetLookup = context.m_255420_(Registries.f_256998_);
        Holder.Reference villageSet = structureSetLookup.m_255043_(BuiltinStructureSets.f_209820_);
        context.m_255272_(VAMPIRE_HUT_SET, (Object)new StructureSet((Holder)structureLookup.m_255043_(VAMPIRE_HUT), (StructurePlacement)new RandomSpreadStructurePlacement(32, 10, RandomSpreadType.LINEAR, 1937195837)));
        context.m_255272_(VAMPIRE_ALTAR_SET, (Object)new StructureSet((Holder)structureLookup.m_255043_(VAMPIRE_ALTAR), (StructurePlacement)new RandomSpreadStructurePlacement(32, 15, RandomSpreadType.LINEAR, 573190874)));
        context.m_255272_(MOTHER_SET, (Object)new StructureSet((Holder)structureLookup.m_255043_(MOTHER), (StructurePlacement)new RandomSpreadStructurePlacement(48, 6, RandomSpreadType.TRIANGULAR, 1897236459)));
        context.m_255272_(CRYPT_SET, (Object)new StructureSet((Holder)structureLookup.m_255043_(CRYPT), (StructurePlacement)new RandomSpreadStructurePlacement(32, 8, RandomSpreadType.LINEAR, 643510199)));
        context.m_255272_(HUNTER_OUTPOST, (Object)new StructureSet(List.of(StructureSet.m_210015_((Holder)structureLookup.m_255043_(HUNTER_OUTPOST_PLAINS)), StructureSet.m_210015_((Holder)structureLookup.m_255043_(HUNTER_OUTPOST_DESERT)), StructureSet.m_210015_((Holder)structureLookup.m_255043_(HUNTER_OUTPOST_VAMPIRE_FOREST)), StructureSet.m_210015_((Holder)structureLookup.m_255043_(HUNTER_OUTPOST_BADLANDS))), (StructurePlacement)new RandomSpreadStructurePlacement(45, 25, RandomSpreadType.LINEAR, 36413509)));
    }

    public static void createStructures(BootstapContext<Structure> context) {
        HolderGetter lookup = context.m_255420_(Registries.f_256952_);
        HolderGetter lookup1 = context.m_255420_(Registries.f_256948_);
        context.m_255272_(VAMPIRE_HUT, (Object)new VampireHutStructure(StructuresAccessor.structure((HolderSet<Biome>)lookup.m_254956_(ModTags.Biomes.HasStructure.VAMPIRE_HUT), TerrainAdjustment.NONE)));
        context.m_255272_(HUNTER_OUTPOST_PLAINS, (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)lookup.m_254956_(ModTags.Biomes.HasStructure.HUNTER_OUTPOST_PLAINS), Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)ModEntities.HUNTER.get(), 80, 2, 4), new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ADVANCED_HUNTER.get(), 20, 1, 22)}))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder)lookup1.m_255043_(PlainsHunterOutpostPools.START), 7, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG));
        context.m_255272_(HUNTER_OUTPOST_DESERT, (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)lookup.m_254956_(ModTags.Biomes.HasStructure.HUNTER_OUTPOST_DESERT), Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)ModEntities.HUNTER.get(), 80, 2, 4), new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ADVANCED_HUNTER.get(), 20, 1, 22)}))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder)lookup1.m_255043_(DesertHunterOutpostPools.START), 7, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG));
        context.m_255272_(HUNTER_OUTPOST_VAMPIRE_FOREST, (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)lookup.m_254956_(ModTags.Biomes.HasStructure.HUNTER_OUTPOST_VAMPIRE_FOREST), Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)ModEntities.HUNTER.get(), 80, 2, 4), new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ADVANCED_HUNTER.get(), 20, 1, 22)}))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder)lookup1.m_255043_(VampireForestHunterOutpostPools.START), 7, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG));
        context.m_255272_(HUNTER_OUTPOST_BADLANDS, (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)lookup.m_254956_(ModTags.Biomes.HasStructure.HUNTER_OUTPOST_BADLANDS), Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)ModEntities.HUNTER.get(), 80, 2, 4), new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ADVANCED_HUNTER.get(), 20, 1, 22)}))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder)lookup1.m_255043_(BadlandsHunterOutpostPools.START), 7, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG));
        context.m_255272_(VAMPIRE_ALTAR, (Object)new VampireAltarStructure(StructuresAccessor.structure((HolderSet<Biome>)lookup.m_254956_(ModTags.Biomes.HasStructure.VAMPIRE_ALTAR), TerrainAdjustment.BEARD_BOX)));
        context.m_255272_(MOTHER, (Object)new MotherStructure(StructuresAccessor.structure((HolderSet<Biome>)lookup.m_254956_(ModTags.Biomes.HasStructure.MOTHER), TerrainAdjustment.NONE)));
        context.m_255272_(CRYPT, (Object)new JigsawStructure(StructuresAccessor.structure((HolderSet<Biome>)lookup.m_254956_(ModTags.Biomes.HasStructure.CRYPT), TerrainAdjustment.BEARD_THIN), (Holder)lookup1.m_255043_(CryptStructurePieces.START), 7, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), false, Heightmap.Types.WORLD_SURFACE_WG));
    }
}

