/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.vampirism.fluids.BloodFluid;
import de.teamlapen.vampirism.fluids.ImpureBloodFluid;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"vampirism");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"vampirism");
    public static final RegistryObject<FluidType> BLOOD_TYPE = FLUID_TYPES.register("blood", () -> new FluidType(FluidType.Properties.create().rarity(Rarity.UNCOMMON).viscosity(3000).temperature(309).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_).density(1300).descriptionId(ModList.get().isLoaded("vampirism_integrations") ? "fluid.vampirism.blood.vampirism" : "fluid.vampirism.blood")){

        public void initializeClient(@NotNull Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                @NotNull
                public ResourceLocation getStillTexture() {
                    return new ResourceLocation("vampirism", "block/blood_still");
                }

                @NotNull
                public ResourceLocation getFlowingTexture() {
                    return new ResourceLocation("vampirism", "block/blood_flow");
                }

                public int getTintColor() {
                    return -285273839;
                }
            });
        }
    });
    public static final RegistryObject<FluidType> IMPURE_BLOOD_TYPE = FLUID_TYPES.register("impure_blood", () -> new FluidType(FluidType.Properties.create().rarity(Rarity.UNCOMMON).viscosity(3000).temperature(309).density(1300).descriptionId(ModList.get().isLoaded("vampirism_integrations") ? "fluid.vampirism.blood.vampirism" : "fluid.vampirism.blood")){

        public void initializeClient(@NotNull Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                @NotNull
                public ResourceLocation getStillTexture() {
                    return new ResourceLocation("vampirism", "block/impure_blood_still");
                }

                @NotNull
                public ResourceLocation getFlowingTexture() {
                    return new ResourceLocation("vampirism", "block/impure_blood_flow");
                }

                public int getTintColor() {
                    return -285273839;
                }
            });
        }
    });
    public static final RegistryObject<Fluid> BLOOD = FLUIDS.register("blood", BloodFluid::new);
    public static final RegistryObject<Fluid> IMPURE_BLOOD = FLUIDS.register("impure_blood", ImpureBloodFluid::new);

    static void register(IEventBus bus) {
        FLUIDS.register(bus);
        FLUID_TYPES.register(bus);
    }
}

