/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.command.arguments.FactionArgument;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class LevelCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"level").requires(context -> context.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"faction", (ArgumentType)FactionArgument.playableFactions()).executes(context -> LevelCommand.setLevel((CommandContext<CommandSourceStack>)context, FactionArgument.getPlayableFaction((CommandContext<CommandSourceStack>)context, "faction"), 1, Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).m_81375_()})))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> LevelCommand.setLevel((CommandContext<CommandSourceStack>)context, FactionArgument.getPlayableFaction((CommandContext<CommandSourceStack>)context, "faction"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level"), Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).m_81375_()})))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91460_()).executes(context -> LevelCommand.setLevel((CommandContext<CommandSourceStack>)context, FactionArgument.getPlayableFaction((CommandContext<CommandSourceStack>)context, "faction"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level"), EntityArgument.m_91477_((CommandContext)context, (String)"player"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"none").executes(context -> LevelCommand.leaveFaction(Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).m_81375_()})))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91460_()).executes(context -> LevelCommand.leaveFaction(EntityArgument.m_91477_((CommandContext)context, (String)"player")))));
    }

    private static int setLevel(@NotNull CommandContext<CommandSourceStack> context, @NotNull IPlayableFaction<?> faction, int level, @NotNull Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            FactionPlayerHandler handler = FactionPlayerHandler.get((Player)player);
            if (level == 0 && !handler.canLeaveFaction()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"command.vampirism.base.level.cant_leave", (Object[])new Object[]{players.size() > 1 ? player.m_5446_() : "Player", handler.getCurrentFaction().getName()}));
                continue;
            }
            if (handler.setFactionAndLevel(faction, level = Math.min(level, faction.getHighestReachableLevel()))) {
                int finalLevel = level;
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.vampirism.base.level.successful", (Object[])new Object[]{player.m_7755_(), faction.getName(), finalLevel}), true);
                continue;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)(players.size() > 1 ? Component.m_237110_((String)"command.vampirism.failed_to_execute.players", (Object[])new Object[]{player.m_5446_()}) : Component.m_237115_((String)"command.vampirism.failed_to_execute")));
        }
        return 0;
    }

    private static int leaveFaction(@NotNull Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            FactionPlayerHandler handler = FactionPlayerHandler.get((Player)player);
            handler.setFactionAndLevel(null, 0);
        }
        return 0;
    }
}

