/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.teamlapen.vampirism.blockentity.CoffinBlockEntity;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.client.renderer.blockentity.VampirismBESR;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CoffinBESR
extends VampirismBESR<CoffinBlockEntity> {
    private static final Marker COFFIN = new MarkerManager.Log4jMarker("COFFIN");
    private final Logger LOGGER = LogManager.getLogger();

    public CoffinBESR(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull CoffinBlockEntity tile, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource iRenderTypeBuffer, int i, int i1) {
        this.renderBlock(tile, partialTicks, matrixStack, iRenderTypeBuffer, i, i1);
    }

    public void renderBlock(@NotNull CoffinBlockEntity tile, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource iRenderTypeBuffer, int i, int i1) {
        assert (tile.m_58904_() != null);
        BlockState state = tile.m_58900_();
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        if (!this.isHeadSafe(tile.m_58904_(), tile.m_58899_())) {
            return;
        }
        matrixStack.m_85836_();
        boolean vertical = (Boolean)state.m_61143_((Property)CoffinBlock.VERTICAL);
        switch (direction) {
            case EAST: {
                if (vertical) {
                    matrixStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                    matrixStack.m_252880_(0.0f, -1.0f, 0.0f);
                }
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                matrixStack.m_252880_(-1.0f, 0.0f, -1.0f);
                break;
            }
            case WEST: {
                if (vertical) {
                    matrixStack.m_252781_(Axis.f_252393_.m_252977_(90.0f));
                    matrixStack.m_252880_(-1.0f, 0.0f, 0.0f);
                }
                matrixStack.m_252781_(Axis.f_252392_.m_252977_(90.0f));
                matrixStack.m_252880_(0.0f, 0.0f, -2.0f);
                break;
            }
            case SOUTH: {
                if (vertical) {
                    matrixStack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
                    matrixStack.m_252880_(0.0f, -1.0f, 0.0f);
                }
                matrixStack.m_252880_(0.0f, 0.0f, -1.0f);
                break;
            }
            case NORTH: {
                if (vertical) {
                    matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                    matrixStack.m_252880_(0.0f, 0.0f, -1.0f);
                }
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                matrixStack.m_252880_(-1.0f, 0.0f, -2.0f);
            }
        }
        BakedModel baseModel = Minecraft.m_91087_().m_91304_().getModel(new ResourceLocation("vampirism", "block/coffin/coffin_bottom_" + tile.color.m_41065_()));
        ModelData modelData = baseModel.getModelData((BlockAndTintGetter)tile.m_58904_(), tile.m_58899_(), state, ModelData.EMPTY);
        for (RenderType renderType : baseModel.getRenderTypes(state, RandomSource.m_216335_((long)42L), modelData)) {
            Minecraft.m_91087_().m_91289_().m_110937_().renderModel(matrixStack.m_85850_(), iRenderTypeBuffer.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)false)), state, baseModel, 1.0f, 1.0f, 1.0f, i, i1, modelData, renderType);
        }
        matrixStack.m_85836_();
        if (vertical) {
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(80.0f * tile.lidPos));
            matrixStack.m_85837_(0.0, -0.5 * (double)tile.lidPos, 0.0);
        } else {
            matrixStack.m_252781_(Axis.f_252392_.m_252977_(35.0f * tile.lidPos));
            matrixStack.m_85837_(0.0, 0.0, -0.5 * (double)tile.lidPos);
        }
        BakedModel lidModel = Minecraft.m_91087_().m_91304_().getModel(new ResourceLocation("vampirism", "block/coffin/coffin_top_" + tile.color.m_41065_()));
        modelData = lidModel.getModelData((BlockAndTintGetter)tile.m_58904_(), tile.m_58899_(), state, ModelData.EMPTY);
        for (RenderType renderType : lidModel.getRenderTypes(state, RandomSource.m_216335_((long)42L), modelData)) {
            Minecraft.m_91087_().m_91289_().m_110937_().renderModel(matrixStack.m_85850_(), iRenderTypeBuffer.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)false)), state, lidModel, 1.0f, 1.0f, 1.0f, i, i1, modelData, renderType);
        }
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }

    private boolean isHeadSafe(@NotNull Level world, @NotNull BlockPos pos) {
        try {
            return CoffinBlock.isHead((BlockGetter)world, pos);
        }
        catch (IllegalArgumentException e) {
            this.LOGGER.error(COFFIN, "Failed to check coffin head at {} caused by wrong blockstate. Block at that pos: {}", (Object)pos, (Object)world.m_8055_(pos));
        }
        catch (Exception e) {
            this.LOGGER.error(COFFIN, "Failed to check coffin head at " + String.valueOf(pos) + ".", (Throwable)e);
        }
        return false;
    }
}

