/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import de.teamlapen.vampirism.client.model.BipedCloakedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BasicHunterModel<T extends LivingEntity>
extends BipedCloakedModel<T> {
    @NotNull
    public static LayerDefinition createBodyLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)BipedCloakedModel.createMesh(false), (int)64, (int)64);
    }

    @NotNull
    public static LayerDefinition createSlimBodyLayer() {
        return LayerDefinition.m_171565_((MeshDefinition)BipedCloakedModel.createMesh(true), (int)64, (int)64);
    }

    public BasicHunterModel(ModelPart part, boolean smallArms) {
        super(part, smallArms);
    }

    @Override
    public void m_6973_(@NotNull T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        HumanoidModel.ArmPose mainPose = BasicHunterModel.getArmPose(entityIn, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose offPose = BasicHunterModel.getArmPose(entityIn, InteractionHand.OFF_HAND);
        if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
            this.f_102816_ = mainPose;
            this.f_102815_ = offPose;
        }
        if (entityIn.m_5737_() == HumanoidArm.LEFT) {
            this.f_102816_ = offPose;
            this.f_102815_ = mainPose;
        }
    }

    private static HumanoidModel.ArmPose getArmPose(LivingEntity entity, InteractionHand pHand) {
        HumanoidModel.ArmPose forgeArmPose;
        ItemStack itemstack = entity.m_21120_(pHand);
        if (itemstack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (entity.m_7655_() == pHand && entity.m_21212_() > 0) {
            UseAnim useanim = itemstack.m_41780_();
            if (useanim == UseAnim.CROSSBOW && pHand == entity.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!entity.f_20911_ && itemstack.m_41720_() instanceof CrossbowItem && CrossbowItem.m_40932_((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        if ((forgeArmPose = IClientItemExtensions.of((ItemStack)itemstack).getArmPose(entity, pHand, itemstack)) != null) {
            return forgeArmPose;
        }
        return HumanoidModel.ArmPose.ITEM;
    }
}

