/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.lib.lib.client.gui.components.HoverList;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.gui.screens.AppearanceScreen;
import de.teamlapen.vampirism.client.renderer.entity.VampireMinionRenderer;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.network.ServerboundAppearancePacket;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class VampireMinionAppearanceScreen
extends AppearanceScreen<VampireMinionEntity> {
    private static final Component NAME = Component.m_237115_((String)"gui.vampirism.minion_appearance");
    private int skinType;
    private boolean useLordSkin;
    private boolean isMinionSpecificSkin;
    private HoverList<?> typeList;
    private ExtendedButton typeButton;
    private Checkbox lordSkinButton;
    private EditBox nameWidget;
    private int normalSkinCount;
    private int minionSkinCount;

    public VampireMinionAppearanceScreen(VampireMinionEntity minion, Screen backScreen) {
        super(NAME, minion, backScreen);
    }

    public void m_7861_() {
        Object name = this.nameWidget.m_94155_();
        if (((String)name).isEmpty()) {
            name = Component.m_237115_((String)"text.vampirism.minion").getString() + String.valueOf(((VampireMinionEntity)this.entity).getMinionId().orElse(0));
        }
        VampirismMod.dispatcher.sendToServer(new ServerboundAppearancePacket(((VampireMinionEntity)this.entity).m_19879_(), (String)name, this.skinType, (this.isMinionSpecificSkin ? 2 : 0) | (this.useLordSkin ? 1 : 0)));
        super.m_7861_();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.nameWidget = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.guiLeft + 21, this.guiTop + 29, 98, 12, (Component)Component.m_237115_((String)"gui.vampirism.minion_appearance.name")));
        this.nameWidget.m_94144_(((VampireMinionEntity)this.entity).getMinionData().map(MinionData::getName).orElse("Minion"));
        this.nameWidget.m_94205_(-1);
        this.nameWidget.m_94202_(-1);
        this.nameWidget.m_94199_(15);
        this.nameWidget.m_94151_(this::onNameChanged);
        this.normalSkinCount = ((VampireMinionRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)((VampireMinionEntity)this.entity))).getVampireTextureCount();
        this.minionSkinCount = ((VampireMinionRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)((VampireMinionEntity)this.entity))).getMinionSpecificTextureCount();
        this.skinType = ((VampireMinionEntity)this.entity).getVampireType();
        this.isMinionSpecificSkin = ((VampireMinionEntity)this.entity).hasMinionSpecificSkin();
        if (this.isMinionSpecificSkin && this.minionSkinCount > 0) {
            this.skinType %= this.minionSkinCount;
        } else {
            this.skinType %= this.normalSkinCount;
            this.isMinionSpecificSkin = false;
        }
        this.useLordSkin = ((VampireMinionEntity)this.entity).shouldRenderLordSkin();
        this.lordSkinButton = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.guiLeft + 20, this.guiTop + 64, 99, 20, (Component)Component.m_237115_((String)"gui.vampirism.minion_appearance.use_lord_skin"), this.useLordSkin){

            public void m_5691_() {
                super.m_5691_();
                VampireMinionAppearanceScreen.this.useLordSkin = this.m_93840_();
                ((VampireMinionEntity)VampireMinionAppearanceScreen.this.entity).setUseLordSkin(VampireMinionAppearanceScreen.this.useLordSkin);
            }
        });
        this.typeList = (HoverList)this.m_142416_((GuiEventListener)HoverList.builder(this.guiLeft + 20, this.guiTop + 43 + 19, 99, 80).componentsWithClickAndHover(IntStream.range(0, this.normalSkinCount + this.minionSkinCount).mapToObj(type -> Component.m_237115_((String)"gui.vampirism.minion_appearance.skin").m_130946_(" " + (type + 1))).toList(), this::skin, this::previewSkin).build());
        this.typeButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.typeList.getLeft(), this.typeList.getTop() - 20, this.typeList.getWidth(), 20, (Component)Component.m_237113_((String)""), button1 -> this.setListVisibility(!this.typeList.isVisible)));
        this.setListVisibility(false);
    }

    public boolean m_7979_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        return super.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    private void onNameChanged(String newName) {
        ((VampireMinionEntity)this.entity).changeMinionName(newName);
    }

    private void previewSkin(int type, boolean hovered) {
        boolean minionSpecific;
        boolean bl = minionSpecific = type >= this.normalSkinCount;
        if (hovered) {
            ((VampireMinionEntity)this.entity).setVampireType(type, minionSpecific);
        } else if (((VampireMinionEntity)this.entity).getVampireType() == type && ((VampireMinionEntity)this.entity).hasMinionSpecificSkin() == minionSpecific) {
            ((VampireMinionEntity)this.entity).setVampireType(this.skinType, this.isMinionSpecificSkin);
        }
    }

    private void setListVisibility(boolean show) {
        this.typeButton.m_93666_((Component)Component.m_237115_((String)"gui.vampirism.minion_appearance.skin").m_130946_(" " + (this.skinType + 1)));
        this.typeList.isVisible = show;
        this.lordSkinButton.f_93624_ = !show;
    }

    private void skin(int type) {
        boolean minionSpecific = type >= this.normalSkinCount;
        this.skinType = type;
        this.isMinionSpecificSkin = minionSpecific;
        ((VampireMinionEntity)this.entity).setVampireType(this.skinType, this.isMinionSpecificSkin);
        this.setListVisibility(false);
    }
}

