/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.player.hunter.HunterLeveling;
import de.teamlapen.vampirism.inventory.HunterTableMenu;
import de.teamlapen.vampirism.items.PureBloodItem;
import de.teamlapen.vampirism.items.VampireBookItem;
import de.teamlapen.vampirism.items.VampireFangItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.CyclingSlotBackground;
import net.minecraft.client.gui.screens.inventory.ItemCombinerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class HunterTableScreen
extends ItemCombinerScreen<HunterTableMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("vampirism", "textures/gui/hunter_table.png");
    private static final ResourceLocation EMPTY_BOOK = new ResourceLocation("vampirism", "item/empty_book");
    private static final ResourceLocation EMPTY_FANG = new ResourceLocation("vampirism", "item/empty_vampire_fang");
    private static final ResourceLocation EMPTY_PURE_BLOOD = new ResourceLocation("vampirism", "item/empty_pure_blood");
    private static final ResourceLocation EMPTY_VAMPIRE_BOOK = new ResourceLocation("vampirism", "item/empty_vampire_book");
    private final CyclingSlotBackground bookIcon = new CyclingSlotBackground(0);
    private final CyclingSlotBackground fangsIcon = new CyclingSlotBackground(1);
    private final CyclingSlotBackground bloodIcon = new CyclingSlotBackground(2);
    private final CyclingSlotBackground vampireBookIcon = new CyclingSlotBackground(3);

    public HunterTableScreen(@NotNull HunterTableMenu inventorySlotsIn, @NotNull Inventory playerInventory, @NotNull Component name) {
        super((ItemCombinerMenu)inventorySlotsIn, playerInventory, name, BACKGROUND);
    }

    protected void m_181908_() {
        super.m_181908_();
        Optional<HunterLeveling.HunterTableRequirement> requirement = ((HunterTableMenu)this.f_97732_).getTableRequirement();
        this.bookIcon.m_266287_(requirement.filter(s -> s.bookQuantity() > 0).map(s -> List.of(EMPTY_BOOK)).orElse(List.of()));
        this.fangsIcon.m_266287_(requirement.filter(s -> s.vampireFangQuantity() > 0).map(s -> List.of(EMPTY_FANG)).orElse(List.of()));
        this.bloodIcon.m_266287_(requirement.filter(s -> s.pureBloodQuantity() > 0).map(s -> List.of(EMPTY_PURE_BLOOD)).orElse(List.of()));
        this.vampireBookIcon.m_266287_(requirement.filter(s -> s.vampireBookQuantity() > 0).map(s -> List.of(EMPTY_VAMPIRE_BOOK)).orElse(List.of()));
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.renderOnBoardingTooltips(graphics, mouseX, mouseY);
    }

    private void renderOnBoardingTooltips(GuiGraphics graphics, int pMouseX, int pMouseY) {
        if (this.f_97734_ != null && this.f_97734_.f_40219_ < 4) {
            ItemStack stack;
            Optional<Object> optional = Optional.empty();
            Optional<HunterLeveling.HunterTableRequirement> req = ((HunterTableMenu)this.f_97732_).getTableRequirement();
            Integer missing = req.map(arg_0 -> this.lambda$renderOnBoardingTooltips$8(stack = this.f_97734_.m_7993_(), arg_0)).orElse(0);
            if (missing > 0) {
                Object[] objectArray = new Object[2];
                objectArray[0] = missing;
                objectArray[1] = switch (this.f_97734_.f_40219_) {
                    case 0 -> Items.f_42517_.m_7968_().m_41786_();
                    case 1 -> ((VampireFangItem)((Object)ModItems.VAMPIRE_FANG.get())).m_7968_().m_41786_();
                    case 2 -> req.map(HunterLeveling.HunterTableRequirement::pureBloodLevel).map(PureBloodItem::getBloodItemForLevel).map(PureBloodItem::getCustomName).orElseGet(Component::m_237119_);
                    case 3 -> ((VampireBookItem)ModItems.VAMPIRE_BOOK.get()).m_7968_().m_41786_();
                    default -> throw new IllegalStateException("Unexpected value: " + this.f_97734_.f_40219_);
                };
                optional = Optional.of(Component.m_237110_((String)"text.vampirism.hunter_table.ritual_missing_items", (Object[])objectArray));
            }
            optional.ifPresent(component -> graphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)component, 115), pMouseX, pMouseY));
        }
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float pPartialTick, int pX, int pY) {
        super.m_7286_(graphics, pPartialTick, pX, pY);
        this.bookIcon.m_266270_(this.f_97732_, graphics, pPartialTick, this.f_97735_, this.f_97736_);
        this.fangsIcon.m_266270_(this.f_97732_, graphics, pPartialTick, this.f_97735_, this.f_97736_);
        this.bloodIcon.m_266270_(this.f_97732_, graphics, pPartialTick, this.f_97735_, this.f_97736_);
        this.vampireBookIcon.m_266270_(this.f_97732_, graphics, pPartialTick, this.f_97735_, this.f_97736_);
    }

    protected void m_266390_(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        Optional<Object> component = Optional.empty();
        Optional<HunterLeveling.HunterTableRequirement> requirement = ((HunterTableMenu)this.f_97732_).getRequirement();
        if (requirement.isEmpty()) {
            component = Optional.of(Component.m_237115_((String)"container.vampirism.hunter_table.level_wrong"));
        } else if (requirement.filter(((HunterTableMenu)this.f_97732_)::doesTableFulfillRequirement).isEmpty()) {
            component = Optional.of(Component.m_237115_((String)"container.vampirism.hunter_table.structure_level_wrong"));
        }
        component.ifPresent(c -> graphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)c, 115), this.f_97735_ + 10, this.f_97736_ + 60));
    }

    private /* synthetic */ Integer lambda$renderOnBoardingTooltips$8(ItemStack stack, HunterLeveling.HunterTableRequirement r) {
        return switch (this.f_97734_.f_40219_) {
            case 0 -> r.bookQuantity() - stack.m_41613_();
            case 1 -> r.vampireFangQuantity() - stack.m_41613_();
            case 2 -> r.pureBloodQuantity() - stack.m_41613_();
            case 3 -> r.vampireBookQuantity() - stack.m_41613_();
            default -> 0;
        };
    }
}

