/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks.mother;

import de.teamlapen.vampirism.blocks.mother.IRemainsBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class MotherTreeStructure {
    private final Set<BlockPos> allBlocks;
    private final Set<BlockPos> vulnerabilities;
    private final Set<BlockPos>[] hierarchy;
    private int validHierarchy;

    public static MotherTreeStructure getTreeView(Level level, BlockPos start) {
        Builder builder = new Builder();
        BlockState mother = level.m_8055_(start);
        assert (mother.m_60734_() == ModBlocks.MOTHER.get());
        builder.addBlock(start, (IRemainsBlock)mother.m_60734_(), mother, 0);
        LinkedList<Pair<Integer, BlockPos>> queue = new LinkedList<Pair<Integer, BlockPos>>();
        queue.add(Pair.of((Object)0, (Object)start));
        while (!queue.isEmpty()) {
            Pair p = (Pair)queue.poll();
            MotherTreeStructure.nextTreeStep(level, (BlockPos)p.getRight(), (Integer)p.getLeft() + 1, queue, builder);
        }
        return builder.build();
    }

    private static void nextTreeStep(Level level, BlockPos currentPos, int nextDepth, Queue<Pair<Integer, BlockPos>> queue, Builder builder) {
        Direction.m_235666_().forEach(dir -> {
            BlockState state;
            Block patt2188$temp;
            BlockPos next = currentPos.m_121945_(dir);
            if (!builder.allBlocks.contains(next) && (patt2188$temp = (state = level.m_8055_(next)).m_60734_()) instanceof IRemainsBlock) {
                IRemainsBlock b = (IRemainsBlock)patt2188$temp;
                builder.addBlock(next, b, state, nextDepth);
                queue.add(Pair.of((Object)nextDepth, (Object)next));
            }
        });
    }

    public static Optional<Pair<BlockPos, BlockState>> findMother(LevelAccessor level, BlockPos pos) {
        return MotherTreeStructure.innerFindMother(level, pos, new HashSet<BlockPos>(), blockState -> blockState.m_60734_() == ModBlocks.MOTHER.get());
    }

    private static Optional<Pair<BlockPos, BlockState>> innerFindMother(LevelAccessor level, BlockPos pos, Set<BlockPos> visited, Predicate<BlockState> predicate) {
        if (visited.contains(pos)) {
            return Optional.empty();
        }
        visited.add(pos);
        BlockState blockState = level.m_8055_(pos);
        if (!(blockState.m_60734_() instanceof IRemainsBlock)) {
            return Optional.empty();
        }
        if (predicate.test(blockState)) {
            return Optional.of(Pair.of((Object)pos, (Object)blockState));
        }
        return Direction.m_235666_().map(arg_0 -> ((BlockPos)pos).m_121945_(arg_0)).map(newPos -> MotherTreeStructure.innerFindMother(level, newPos, visited, predicate)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public MotherTreeStructure(Set<BlockPos> allBlocks, Set<BlockPos> vulnerabilities, Set<BlockPos>[] hierarchy) {
        this.allBlocks = allBlocks;
        this.vulnerabilities = vulnerabilities;
        this.hierarchy = hierarchy;
        this.validHierarchy = hierarchy.length - 1;
    }

    public Set<BlockPos> getCachedBlocks() {
        return this.allBlocks;
    }

    public Set<BlockPos> getCachedVulnerabilities() {
        return this.vulnerabilities;
    }

    public Stream<Triple<BlockPos, BlockState, IRemainsBlock>> getVerifiedVulnerabilities(Level level) {
        return this.getCachedVulnerabilities().stream().map(pos -> {
            IRemainsBlock b;
            BlockState bs = level.m_8055_(pos);
            Block patt5053$temp = bs.m_60734_();
            if (patt5053$temp instanceof IRemainsBlock && (b = (IRemainsBlock)patt5053$temp).isVulnerability(bs)) {
                return Triple.of((Object)pos, (Object)bs, (Object)b);
            }
            return null;
        }).filter(Objects::nonNull);
    }

    public Optional<Set<BlockPos>> popHierarchy() {
        if (this.validHierarchy > 0) {
            Set<BlockPos> set = this.hierarchy[this.validHierarchy];
            this.allBlocks.removeAll(set);
            this.vulnerabilities.removeAll(set);
            --this.validHierarchy;
            return Optional.of(set);
        }
        return Optional.empty();
    }

    private static class Builder {
        public final Set<BlockPos> allBlocks = new HashSet<BlockPos>();
        private final Set<BlockPos> vulnerabilities = new HashSet<BlockPos>();
        private final ArrayList<Set<BlockPos>> hierarchy = new ArrayList();

        private Builder() {
        }

        public void addBlock(BlockPos pos, IRemainsBlock block, BlockState state, int depth) {
            this.allBlocks.add(pos);
            if (block.isVulnerability(state)) {
                this.vulnerabilities.add(pos);
            }
            if (depth < this.hierarchy.size()) {
                this.hierarchy.get(depth).add(pos);
            } else if (depth == this.hierarchy.size()) {
                HashSet<BlockPos> p = new HashSet<BlockPos>();
                p.add(pos);
                this.hierarchy.add(p);
            } else {
                throw new IllegalStateException("Max fucked up");
            }
        }

        public MotherTreeStructure build() {
            return new MotherTreeStructure(this.allBlocks, this.vulnerabilities, this.hierarchy.toArray(new Set[0]));
        }
    }
}

