/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class SunscreenBeaconBlockEntity
extends BlockEntity {
    private BlockPos oldPos;
    private Predicate<Player> selector;

    public SunscreenBeaconBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModTiles.SUNSCREEN_BEACON.get(), pos, state);
    }

    public static void serverTick(@NotNull Level level, @NotNull BlockPos pos, BlockState state, @NotNull SunscreenBeaconBlockEntity blockEntity) {
        if (level.m_46467_() % 80L == 0L) {
            if (blockEntity.oldPos == null || blockEntity.selector == null || !blockEntity.oldPos.equals((Object)pos)) {
                blockEntity.oldPos = pos;
                BlockPos center = new BlockPos(pos.m_123341_(), 0, pos.m_123343_());
                int distSq = (Integer)VampirismConfig.SERVER.sunscreenBeaconDistance.get() * (Integer)VampirismConfig.SERVER.sunscreenBeaconDistance.get();
                blockEntity.selector = input -> {
                    if (input == null) {
                        return false;
                    }
                    BlockPos player = new BlockPos((int)input.m_20185_(), 0, (int)input.m_20189_());
                    return player.m_123331_((Vec3i)center) < (double)distSq;
                };
            }
            List list = level.m_6907_();
            for (Player player : list) {
                if (!player.m_6084_() || !blockEntity.selector.test(player) || VampirismPlayerAttributes.get((Player)player).vampireLevel <= 0) continue;
                player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SUNSCREEN.get(), 160, 5, true, false));
            }
        }
    }
}

