/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.general;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.api.VReference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BloodConversionRegistry {
    @NotNull
    private static final Map<ResourceLocation, Float> items = Maps.newHashMap();
    @NotNull
    private static final Map<ResourceLocation, Float> fluids = Maps.newHashMap();
    @NotNull
    private static final Map<ResourceLocation, Float> entities = Maps.newHashMap();
    @NotNull
    private static final Map<ResourceLocation, Float> items_calculated = Maps.newHashMap();
    @NotNull
    private static final Set<ResourceLocation> items_blacklist = Sets.newHashSet();

    public static void applyNewFluidResources(@NotNull Map<ResourceLocation, Float> values) {
        fluids.clear();
        fluids.putAll(values);
    }

    public static void applyNewEntitiesResources(@NotNull Map<ResourceLocation, Float> values) {
        entities.clear();
        entities.putAll(values);
    }

    public static void applyNewItemResources(@NotNull Map<ResourceLocation, Float> values) {
        items.clear();
        for (Map.Entry<ResourceLocation, Float> value : values.entrySet()) {
            if (value.getValue().floatValue() != 0.0f) {
                items.put(value.getKey(), value.getValue());
                continue;
            }
            items_blacklist.add(value.getKey());
        }
    }

    @NotNull
    public static Map<ResourceLocation, Float> getItemConversions() {
        return Collections.unmodifiableMap(items);
    }

    @NotNull
    public static Map<ResourceLocation, Float> getEntityConversions() {
        return Collections.unmodifiableMap(entities);
    }

    @NotNull
    public static Map<ResourceLocation, Float> getFluidConversions() {
        return Collections.unmodifiableMap(fluids);
    }

    @NotNull
    public static Map<ResourceLocation, Float> getItemConversionCalculated() {
        return Collections.unmodifiableMap(items_calculated);
    }

    public static int getImpureBloodValue(@NotNull Item item) {
        if (items.containsKey(BloodConversionRegistry.id(item)) || items_calculated.containsKey(BloodConversionRegistry.id(item))) {
            return (items.containsKey(BloodConversionRegistry.id(item)) ? items.get(BloodConversionRegistry.id(item)) : items_calculated.get(BloodConversionRegistry.id(item))).intValue();
        }
        return 0;
    }

    public static boolean canBeConverted(@NotNull ItemStack stack) {
        int value;
        ResourceLocation id = BloodConversionRegistry.id(stack.m_41720_());
        if (items.containsKey(id) || items_calculated.containsKey(id)) {
            return true;
        }
        if (items_blacklist.contains(id)) {
            return false;
        }
        if (stack.m_41614_() && stack.getFoodProperties(null).m_38746_() && (value = Mth.m_14045_((int)(id != null && id.m_135815_().contains("cooked") ? 0 : stack.getFoodProperties(null).m_38744_() / 2), (int)0, (int)5)) > 0) {
            items_calculated.put(id, Float.valueOf(value * 100));
            return true;
        }
        items_blacklist.add(id);
        return false;
    }

    public static float getBloodValue(@NotNull FluidStack fluid) {
        if (fluids.containsKey(BloodConversionRegistry.id(fluid.getFluid()))) {
            return fluids.get(BloodConversionRegistry.id(fluid.getFluid())).floatValue();
        }
        return 0.0f;
    }

    public static boolean existsBloodValue(@NotNull Fluid fluid) {
        return fluids.containsKey(BloodConversionRegistry.id(fluid));
    }

    @NotNull
    public static FluidStack getBloodFromFluid(@NotNull FluidStack fluid) {
        if (fluid.getFluid().m_6212_((Fluid)VReference.BLOOD.get())) {
            return fluid;
        }
        return new FluidStack((Fluid)VReference.BLOOD.get(), (int)(BloodConversionRegistry.getBloodValue(fluid) * (float)fluid.getAmount()));
    }

    @Nullable
    public static ResourceLocation id(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    @Nullable
    public static ResourceLocation id(Fluid block) {
        return ForgeRegistries.FLUIDS.getKey((Object)block);
    }
}

