/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.skills;

import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public abstract class DefaultSkill<T extends IFactionPlayer<T>>
implements ISkill<T> {
    private final Map<Attribute, LazyOptional<AttributeModifier>> attributeModifierMap = new HashMap<Attribute, LazyOptional<AttributeModifier>>();
    private final @Range(from=0L, to=9L) int skillPointCost;
    private int renderRow;
    private int renderColumn;
    private Component name;

    public DefaultSkill() {
        this(1);
    }

    public DefaultSkill(@Range(from=0L, to=9L) int skillPointCost) {
        this.skillPointCost = skillPointCost;
    }

    @Override
    public Component getName() {
        return this.name == null ? (this.name = Component.m_237115_((String)this.getTranslationKey())) : this.name;
    }

    @NotNull
    public DefaultSkill<T> setName(Component name) {
        this.name = name;
        return this;
    }

    @Override
    public int getRenderColumn() {
        return this.renderColumn;
    }

    @Override
    public int getRenderRow() {
        return this.renderRow;
    }

    @Override
    @Deprecated
    public String getTranslationKey() {
        return "skill." + this.getRegistryName().m_135827_() + "." + this.getRegistryName().m_135815_();
    }

    @Override
    public final void onDisable(@NotNull T player) {
        this.removeAttributesModifiersFromEntity(player.getRepresentingPlayer());
        player.getActionHandler().relockActions(this.getActions());
        if (!this.getFaction().map(f -> f.getFactionPlayerInterface().isInstance(player)).orElse(true).booleanValue()) {
            throw new IllegalArgumentException("Faction player instance is of wrong class " + String.valueOf(player.getClass()) + " instead of " + String.valueOf(this.getFaction().get().getFactionPlayerInterface()));
        }
        this.onDisabled(player);
    }

    @Override
    public final void onEnable(@NotNull T player) {
        this.applyAttributesModifiersToEntity(player.getRepresentingPlayer());
        player.getActionHandler().unlockActions(this.getActions());
        if (!this.getFaction().map(f -> f.getFactionPlayerInterface().isInstance(player)).orElse(true).booleanValue()) {
            throw new IllegalArgumentException("Faction player instance is of wrong class " + String.valueOf(player.getClass()) + " instead of " + String.valueOf(this.getFaction().get().getFactionPlayerInterface()));
        }
        this.onEnabled(player);
    }

    @NotNull
    public DefaultSkill<T> registerAttributeModifier(Attribute attribute, @NotNull String uuid, double amount, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull AttributeModifier.Operation operation) {
        AttributeModifier attributemodifier = new AttributeModifier(UUID.fromString(uuid), this.getRegistryName().toString(), amount, operation);
        this.attributeModifierMap.put(attribute, (LazyOptional<AttributeModifier>)LazyOptional.of(() -> attributemodifier));
        return this;
    }

    @NotNull
    public DefaultSkill<T> registerAttributeModifier(Attribute attribute, @NotNull String uuid, @NotNull Supplier<Double> amountSupplier, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull AttributeModifier.Operation operation) {
        this.attributeModifierMap.put(attribute, (LazyOptional<AttributeModifier>)LazyOptional.of(() -> new AttributeModifier(UUID.fromString(uuid), this.getRegistryName().toString(), ((Double)amountSupplier.get()).doubleValue(), operation)));
        return this;
    }

    @Override
    public void setRenderPos(int row, int column) {
        this.renderRow = row;
        this.renderColumn = column;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.getRegistryName()) + "(" + this.getClass().getSimpleName() + ")";
    }

    protected void getActions(Collection<IAction<T>> list) {
    }

    protected void onDisabled(T player) {
    }

    protected void onEnabled(T player) {
    }

    private void applyAttributesModifiersToEntity(@NotNull Player player) {
        for (Map.Entry<Attribute, LazyOptional<AttributeModifier>> entry : this.attributeModifierMap.entrySet()) {
            AttributeInstance instance = player.m_21051_(entry.getKey());
            if (instance == null) continue;
            AttributeModifier attributemodifier = (AttributeModifier)entry.getValue().orElseThrow(IllegalStateException::new);
            instance.m_22130_(attributemodifier);
            instance.m_22125_(new AttributeModifier(attributemodifier.m_22209_(), this.getRegistryName().toString(), attributemodifier.m_22218_(), attributemodifier.m_22217_()));
        }
    }

    @NotNull
    private Collection<IAction<T>> getActions() {
        ArrayList<IAction<IAction>> collection = new ArrayList<IAction<IAction>>();
        this.getActions(collection);
        collection.forEach(iAction -> {
            if (iAction.getFaction().isPresent() && iAction.getFaction().get() != this.getFaction().orElse(null)) {
                throw new IllegalArgumentException("Can't register action of faction " + (String)iAction.getFaction().map(Object::toString).orElse(null) + " for skill of faction" + this.getFaction().map(Object::toString).orElse("all"));
            }
        });
        return collection;
    }

    private void removeAttributesModifiersFromEntity(@NotNull Player player) {
        for (Map.Entry<Attribute, LazyOptional<AttributeModifier>> entry : this.attributeModifierMap.entrySet()) {
            AttributeInstance attribute = player.m_21051_(entry.getKey());
            if (attribute == null) continue;
            attribute.m_22130_((AttributeModifier)entry.getValue().orElseThrow(IllegalStateException::new));
        }
    }

    @Nullable
    private ResourceLocation getRegistryName() {
        return VampirismRegistries.SKILLS.get().getKey((Object)this);
    }

    @Override
    public @Range(from=0L, to=9L) int getSkillPointCost() {
        return this.skillPointCost;
    }
}

