/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.network;

import com.google.common.collect.ImmutableCollection;
import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.lib.network.IMessage;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientboundUpdateEntityPacket
implements IMessage.IClientBoundMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private int id;
    private CompoundTag data;
    private CompoundTag caps;
    private boolean playerItself = false;

    static void encode(@NotNull ClientboundUpdateEntityPacket msg, @NotNull FriendlyByteBuf buf) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("id", msg.id);
        if (msg.data != null) {
            tag.m_128365_("data", (Tag)msg.data);
        }
        if (msg.caps != null) {
            tag.m_128365_("caps", (Tag)msg.caps);
        }
        if (msg.playerItself) {
            tag.m_128379_("itself", true);
        }
        buf.m_130079_(tag);
    }

    @NotNull
    static ClientboundUpdateEntityPacket decode(@NotNull FriendlyByteBuf buf) {
        CompoundTag tag = buf.m_130260_();
        ClientboundUpdateEntityPacket pkt = new ClientboundUpdateEntityPacket();
        pkt.id = tag.m_128451_("id");
        if (tag.m_128441_("data")) {
            pkt.data = tag.m_128469_("data");
        }
        if (tag.m_128441_("caps")) {
            pkt.caps = tag.m_128469_("caps");
        }
        if (tag.m_128441_("itself")) {
            pkt.playerItself = tag.m_128471_("itself");
        }
        return pkt;
    }

    public static void handle(ClientboundUpdateEntityPacket message, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampLib.proxy.handleUpdateEntityPacket(message));
        ctx.setPacketHandled(true);
    }

    @NotNull
    public static ClientboundUpdateEntityPacket create(@NotNull ISyncable.ISyncableEntityCapabilityInst cap) {
        CompoundTag data = new CompoundTag();
        cap.writeFullUpdateToNBT(data);
        return ClientboundUpdateEntityPacket.create(cap, data);
    }

    @NotNull
    public static ClientboundUpdateEntityPacket create(Mob entity, ISyncable.ISyncableEntityCapabilityInst ... caps) {
        if (!(entity instanceof ISyncable)) {
            throw new IllegalArgumentException("You cannot use this packet to sync this entity. The entity has to implement ISyncable");
        }
        ClientboundUpdateEntityPacket packet = ClientboundUpdateEntityPacket.create(caps);
        packet.data = new CompoundTag();
        ((ISyncable)entity).writeFullUpdateToNBT(packet.data);
        return packet;
    }

    @NotNull
    public static ClientboundUpdateEntityPacket create(ISyncable.ISyncableEntityCapabilityInst ... caps) {
        ClientboundUpdateEntityPacket packet = new ClientboundUpdateEntityPacket();
        packet.id = caps[0].getTheEntityID();
        packet.caps = new CompoundTag();
        for (ISyncable.ISyncableEntityCapabilityInst cap : caps) {
            CompoundTag data = new CompoundTag();
            cap.writeFullUpdateToNBT(data);
            packet.caps.m_128365_(cap.getCapKey().toString(), (Tag)data);
        }
        return packet;
    }

    @NotNull
    public static ClientboundUpdateEntityPacket create(@NotNull ISyncable.ISyncableEntityCapabilityInst cap, @NotNull CompoundTag data) {
        ClientboundUpdateEntityPacket packet = new ClientboundUpdateEntityPacket();
        packet.id = cap.getTheEntityID();
        packet.caps = new CompoundTag();
        packet.caps.m_128365_(cap.getCapKey().toString(), (Tag)data);
        return packet;
    }

    @NotNull
    public static ClientboundUpdateEntityPacket create(Entity entity) {
        if (!(entity instanceof ISyncable)) {
            throw new IllegalArgumentException("You cannot use this packet to sync this entity. The entity has to implement ISyncable");
        }
        ClientboundUpdateEntityPacket packet = new ClientboundUpdateEntityPacket();
        packet.id = entity.m_19879_();
        packet.data = new CompoundTag();
        ((ISyncable)entity).writeFullUpdateToNBT(packet.data);
        return packet;
    }

    @NotNull
    public static <T extends Entity> ClientboundUpdateEntityPacket create(@NotNull T entity, CompoundTag data) {
        ClientboundUpdateEntityPacket packet = new ClientboundUpdateEntityPacket();
        packet.id = entity.m_19879_();
        packet.data = data;
        return packet;
    }

    @Nullable
    public static ClientboundUpdateEntityPacket createJoinWorldPacket(Entity entity) {
        ArrayList capsToSync = new ArrayList();
        ImmutableCollection allCaps = null;
        if (entity instanceof PathfinderMob) {
            allCaps = HelperRegistry.getSyncableEntityCaps().values();
        } else if (entity instanceof Player) {
            allCaps = HelperRegistry.getSyncablePlayerCaps().values();
        }
        if (allCaps != null && allCaps.size() > 0) {
            for (Capability cap : allCaps) {
                entity.getCapability(cap, null).ifPresent(capsToSync::add);
            }
        }
        if (capsToSync.size() > 0) {
            if (entity instanceof ISyncable) {
                return ClientboundUpdateEntityPacket.create((Mob)entity, capsToSync.toArray(new ISyncable.ISyncableEntityCapabilityInst[0]));
            }
            return ClientboundUpdateEntityPacket.create(capsToSync.toArray(new ISyncable.ISyncableEntityCapabilityInst[0]));
        }
        if (entity instanceof ISyncable) {
            return ClientboundUpdateEntityPacket.create(entity);
        }
        LOGGER.warn("There is nothing to update for entity {}", (Object)entity);
        return null;
    }

    public CompoundTag getCaps() {
        return this.caps;
    }

    public CompoundTag getData() {
        return this.data;
    }

    public int getId() {
        return this.id;
    }

    public boolean isPlayerItself() {
        return this.playerItself;
    }

    @NotNull
    public ClientboundUpdateEntityPacket markAsPlayerItself() {
        this.playerItself = true;
        return this;
    }
}

