/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.entity.trade;

import com.yungnickyoung.minecraft.ribbits.entity.trade.ItemListing;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class PotionForAmethyst
implements ItemListing {
    private final ItemStack toItem;
    private final int count;
    private final int amethystCostMin;
    private final int amethystCostMax;
    private final int maxUses;
    private final float priceMultiplier;
    @Nullable
    private final Potion potionType;

    public PotionForAmethyst(ItemLike toItem, @Nullable Potion potionType, int count, int amethystCostMin, int amethystCostMax, int maxUses) {
        this.toItem = new ItemStack(toItem);
        this.count = count;
        this.amethystCostMin = amethystCostMin;
        this.amethystCostMax = amethystCostMax;
        this.maxUses = maxUses;
        this.priceMultiplier = 0.05f;
        this.potionType = potionType;
    }

    @Override
    public MerchantOffer getOffer(Entity entity, RandomSource rand) {
        ItemStack potionStack;
        ItemStack amethystStack = new ItemStack((ItemLike)Items.f_151049_, rand.m_216332_(this.amethystCostMin, this.amethystCostMax));
        if (this.potionType == null) {
            List<Potion> potionList = BuiltInRegistries.f_256980_.m_123024_().filter(potion -> !potion.m_43488_().isEmpty() && PotionBrewing.m_43511_((Potion)potion)).toList();
            Potion potionEffect = potionList.get(rand.m_188503_(potionList.size()));
            potionStack = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)this.toItem.m_41720_(), this.count), (Potion)potionEffect);
        } else {
            potionStack = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)this.toItem.m_41720_(), this.count), (Potion)this.potionType);
        }
        return new MerchantOffer(amethystStack, potionStack, this.maxUses, 0, this.priceMultiplier);
    }
}

