/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class FNRuntimeUtil {
    private static final Map<Runnable, Long> lastTimes = new HashMap<Runnable, Long>();
    private static final List<Timer> timers = new ArrayList<Timer>();

    public static void loopDayRunner(@NotNull Timer timer, @NotNull Executor executor, @Range(from=0L, to=23L) int hours, @Range(from=0L, to=59L) int minutes, @NotNull Runnable runnable) {
        FNRuntimeUtil.loopDayRunner(timer, executor, hours, minutes, 0, runnable);
    }

    public static void loopDayRunner(@NotNull Timer timer, @NotNull Executor executor, @Range(from=0L, to=23L) int hours, @Range(from=0L, to=59L) int minutes, @Range(from=0L, to=59L) int second, @NotNull Runnable runnable) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if (calendar.get(11) > hours || calendar.get(11) == hours && calendar.get(12) > minutes || calendar.get(11) == hours && calendar.get(12) == minutes && calendar.get(13) >= second) {
            calendar.add(5, 1);
        }
        calendar.set(11, hours);
        calendar.set(12, minutes);
        calendar.set(13, second);
        FNRuntimeUtil.loopDayRunner_(calendar, timer, executor, runnable);
    }

    private static void loopDayRunner_(Calendar calendar, Timer timer, Executor executor, Runnable runnable) {
        FNRuntimeUtil.dayRunner(timer, executor, calendar.getTime(), () -> {
            calendar.add(5, 1);
            FNRuntimeUtil.loopDayRunner_(calendar, timer, executor, runnable);
            runnable.run();
        });
    }

    public static void dayRunner(@NotNull Timer timer, final @NotNull Executor executor, @NotNull Date date, final @NotNull Runnable runnable) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                CompletableFuture.runAsync(runnable, executor);
            }
        };
        timer.schedule(task, date);
    }

    public static void loopRunner(@NotNull Timer timer, @NotNull Executor executor, @NotNull TimeUnit delayTimeUnit, long delayDuration, @NotNull Runnable runnable) {
        FNRuntimeUtil.loopRunner(timer, executor, false, delayTimeUnit, delayDuration, runnable);
    }

    public static void loopRunner(@NotNull Timer timer, final @NotNull Executor executor, boolean startDelay, @NotNull TimeUnit delayTimeUnit, long delayDuration, final @NotNull Runnable runnable) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                CompletableFuture.runAsync(runnable, executor);
            }
        };
        long time = delayTimeUnit.toMillis(delayDuration);
        timer.scheduleAtFixedRate(task, startDelay ? time : 0L, time);
    }

    public static void delayRunner(@NotNull Timer timer, final @NotNull Executor executor, @NotNull TimeUnit delayTimeUnit, long delayDuration, final @NotNull Runnable runnable) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                CompletableFuture.runAsync(runnable, executor);
            }
        };
        timer.schedule(task, delayTimeUnit.toMillis(delayDuration));
    }

    public static void oneDayClockTimer(int hours, int minutes, Runnable runnable) {
        FNRuntimeUtil.oneDayClockTimer(hours, minutes, runnable, false);
    }

    public static void oneDayClockTimer(final int hours, final int minutes, final Runnable runnable, boolean daemon) {
        Timer timer = new Timer(daemon);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                Date date;
                long lastTime = 0L;
                if (lastTimes.containsKey(runnable)) {
                    lastTime = (Long)lastTimes.get(runnable);
                }
                if (System.currentTimeMillis() - lastTime > 3600000L && (date = new Date()).getHours() == hours && date.getMinutes() == minutes) {
                    runnable.run();
                    lastTimes.put(runnable, System.currentTimeMillis());
                }
            }
        };
        timer.schedule(task, 0L, 1000L);
        timers.add(timer);
    }

    @Deprecated
    public static CompletableFuture<Void> multipleRun(Runnable runnable, Runnable ... runnables) {
        return FNRuntimeUtil.multipleRun(null, -1, runnable, runnables);
    }

    @Deprecated
    public static CompletableFuture<Void> multipleRun(String threadName, Runnable runnable, Runnable ... runnables) {
        return FNRuntimeUtil.multipleRun(threadName, -1, runnable, runnables);
    }

    @Deprecated
    public static CompletableFuture<Void> multipleRun(int max, Runnable runnable, Runnable ... runnables) {
        return FNRuntimeUtil.multipleRun(null, max, runnable, runnables);
    }

    @Deprecated
    public static CompletableFuture<Void> multipleRun(String threadName, int max, Runnable runnable, Runnable ... runnables) {
        if (max <= 0) {
            max = 1 + runnables.length;
        }
        int mx = max;
        return CompletableFuture.runAsync(() -> {
            Object obj = new Object();
            AtomicInteger fin = new AtomicInteger();
            AtomicInteger maxFin = new AtomicInteger();
            ArrayList<Thread> runners = new ArrayList<Thread>();
            runners.add(new Thread(() -> {
                runnable.run();
                Object object = obj;
                synchronized (object) {
                    fin.getAndIncrement();
                    if (fin.get() >= maxFin.get()) {
                        obj.notifyAll();
                    }
                }
            }));
            for (Runnable run : runnables) {
                runners.add(new Thread(() -> {
                    run.run();
                    Object object = obj;
                    synchronized (object) {
                        fin.getAndIncrement();
                        if (fin.get() >= maxFin.get()) {
                            obj.notifyAll();
                        }
                    }
                }));
            }
            if (threadName != null) {
                for (int i = 0; i < runners.size(); ++i) {
                    ((Thread)runners.get(i)).setName(threadName + "-" + i);
                }
            }
            do {
                ArrayList<Thread> rms = new ArrayList<Thread>();
                int ct = 0;
                for (Thread runner : runners) {
                    rms.add(runner);
                    if (++ct < mx) continue;
                    break;
                }
                maxFin.set(ct);
                rms.forEach(Thread::start);
                runners.removeAll(rms);
                Object object = obj;
                synchronized (object) {
                    try {
                        if (fin.get() < maxFin.get()) {
                            obj.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                fin.set(0);
            } while (!runners.isEmpty());
        });
    }

    public static void kill() {
        for (Timer timer : timers) {
            timer.cancel();
            timer.purge();
        }
        timers.clear();
        lastTimes.clear();
    }
}

