/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.data.provider.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.provider.ModelProcessProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.model.ModelProcessSubProviderWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.data.CachedOutput;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class DivisionModelProcessSubProviderWrapper
extends ModelProcessSubProviderWrapper {
    public DivisionModelProcessSubProviderWrapper(CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(crossDataGeneratorAccess);
    }

    @Override
    public List<ModelProcessProviderWrapper.ModelData> process(CachedOutput cachedOutput, ModelProcessProviderWrapper.ModelData modelData) {
        return this.divModel(modelData.getName(), modelData.model()).entrySet().stream().map(n -> {
            String p = modelData.location().m_135815_();
            CharSequence[] ps = p.split("/");
            ps[ps.length - 1] = (String)n.getKey();
            return new ModelProcessProviderWrapper.ModelData(new ResourceLocation(modelData.location().m_135827_(), String.join((CharSequence)"/", ps)), (JsonObject)n.getValue());
        }).toList();
    }

    private Map<String, JsonObject> divModel(String name, JsonObject original) {
        JsonArray groups = original.getAsJsonArray("groups");
        if (groups == null) {
            return ImmutableMap.of((Object)name, (Object)original);
        }
        HashMap divGroups = new HashMap();
        for (JsonElement group : groups) {
            JsonObject jsonObject;
            if (group instanceof JsonObject && (jsonObject = (JsonObject)group).has("name") && this.isDivGroup(jsonObject.get("name").getAsString())) {
                String gname = this.convertDivGroupName(jsonObject.get("name").getAsString());
                divGroups.putIfAbsent(gname, new ArrayList());
                ((List)divGroups.get(gname)).add(group);
                continue;
            }
            divGroups.putIfAbsent(name, new ArrayList());
            ((List)divGroups.get(name)).add(group);
        }
        JsonArray orelement = original.getAsJsonArray("elements");
        return divGroups.entrySet().stream().map(ent -> Pair.of((Object)((String)ent.getKey()), ((List)ent.getValue()).stream().flatMap(r -> this.getAllChildren((JsonElement)r).stream()).toList())).map(ent -> {
            JsonObject oriCopy = original.deepCopy();
            oriCopy.remove("elements");
            oriCopy.remove("groups");
            JsonArray nelements = new JsonArray();
            for (Integer integer : (List)ent.getRight()) {
                nelements.add(orelement.get(integer.intValue()));
            }
            oriCopy.add("elements", (JsonElement)nelements);
            return Pair.of((Object)((String)ent.getLeft()), (Object)oriCopy);
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    private List<Integer> getAllChildren(JsonElement group) {
        JsonPrimitive jsonPrimitive;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (group instanceof JsonObject) {
            JsonObject groupJson = (JsonObject)group;
            JsonArray children = groupJson.getAsJsonArray("children");
            for (JsonElement child : children) {
                ret.addAll(this.getAllChildren(child));
            }
        } else if (group instanceof JsonPrimitive && (jsonPrimitive = (JsonPrimitive)group).isNumber()) {
            ret.add(jsonPrimitive.getAsInt());
        }
        return ret;
    }

    protected boolean isDivGroup(String groupName) {
        return groupName.startsWith("_");
    }

    protected String convertDivGroupName(String groupName) {
        return groupName.substring(1);
    }
}

