/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.data.provider;

import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.provider.DataProviderWrapper;
import dev.felnull.otyacraftengine.tag.ManualTagHolder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public abstract class TagProviderWrapper<T, A extends TagProviderAccess<T, ? extends TagAppenderWrapper<T>>>
extends DataProviderWrapper<TagsProvider<T>> {
    private final CompletableFuture<HolderLookup.Provider> lookup;

    public TagProviderWrapper(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookup, CrossDataGeneratorAccess crossDataGeneratorAccess) {
        super(packOutput, crossDataGeneratorAccess);
        this.lookup = lookup;
    }

    public CompletableFuture<HolderLookup.Provider> getLookup() {
        return this.lookup;
    }

    public abstract void generateTag(A var1);

    public static interface TagAppenderWrapper<T> {
        public TagAppenderWrapper<T> addTag(TagKey<T> var1);

        public TagAppenderWrapper<T> add(ResourceKey<T> var1);

        public TagAppenderWrapper<T> add(ResourceKey<T> ... var1);

        public TagAppenderWrapper<T> addOptional(ResourceLocation var1);

        public TagAppenderWrapper<T> addOptionalTag(ResourceLocation var1);

        default public TagAppenderWrapper<T> addTags(List<TagKey<T>> tagKeys) {
            TagAppenderWrapper<T> appenderWrapper = this;
            for (TagKey<T> tagKey : tagKeys) {
                appenderWrapper = appenderWrapper.addTag(tagKey);
            }
            return appenderWrapper;
        }

        default public TagAppenderWrapper<T> addTagHolders(List<ManualTagHolder<T>> tagHolders) {
            TagAppenderWrapper<T> appenderWrapper = this;
            for (ManualTagHolder<T> tagHolder : tagHolders) {
                appenderWrapper = appenderWrapper.addTagHolder(tagHolder);
            }
            return appenderWrapper;
        }

        default public TagAppenderWrapper<T> addOptionalTag(ResourceLocation ... resourceLocations) {
            TagAppenderWrapper<T> appenderWrapper = this;
            for (ResourceLocation resourceLocation : resourceLocations) {
                appenderWrapper = appenderWrapper.addOptionalTag(resourceLocation);
            }
            return appenderWrapper;
        }

        default public TagAppenderWrapper<T> addTagHolder(ManualTagHolder<T> tagHolder) {
            return this.addTag(tagHolder.getKey());
        }

        default public TagAppenderWrapper<T> addVanillaTag(TagKey<T> tagKey) {
            return this.addTag(tagKey);
        }
    }

    public static interface TagProviderAccess<T, W extends TagAppenderWrapper<T>> {
        public W tag(TagKey<T> var1);
    }
}

