/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.data.provider;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.data.CrossDataGeneratorAccess;
import dev.felnull.otyacraftengine.data.provider.InputBaseProviderWrapper;
import dev.felnull.otyacraftengine.data.provider.model.ModelProcessSubProviderWrapper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModelProcessProviderWrapper
extends InputBaseProviderWrapper {
    private static final Gson GSON = new Gson();
    private final List<ModelProcessSubProviderWrapper> subProviderWrappers;

    public ModelProcessProviderWrapper(PackOutput packOutput, CrossDataGeneratorAccess crossDataGeneratorAccess, List<ModelProcessSubProviderWrapper> subProviderWrappers) {
        super(packOutput, PackOutput.Target.RESOURCE_PACK, "models", crossDataGeneratorAccess);
        this.subProviderWrappers = subProviderWrappers;
    }

    @Override
    public String getName() {
        return "Model Process";
    }

    @Override
    @Nullable
    protected CompletableFuture<?> runTask(CachedOutput cachedOutput, Path inputRoot, Path target) {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Pair<ResourceLocation, String> locEx = this.toResourceLocationAndExtension(inputRoot, target);
            try (FileReader reader = new FileReader(target.toFile());){
                ModelData modelData;
                try (BufferedReader bufReadr = new BufferedReader(reader);){
                    modelData = new ModelData((ResourceLocation)locEx.getLeft(), (JsonObject)GSON.fromJson((Reader)bufReadr, JsonObject.class));
                }
                return modelData;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, Util.m_183991_()).thenComposeAsync(r -> this.runConvert(cachedOutput, (ModelData)r), (Executor)Util.m_183991_())).handleAsync((models, throwable) -> models, (Executor)Util.m_183991_())).thenComposeAsync(models -> {
            if (models != null) {
                ArrayList<CompletableFuture> saves = new ArrayList<CompletableFuture>();
                for (ModelData model : models) {
                    saves.add(DataProvider.m_253162_((CachedOutput)cachedOutput, (JsonElement)model.model(), (Path)this.pathProvider.m_245731_(model.location())));
                }
                return CompletableFuture.allOf((CompletableFuture[])saves.toArray(CompletableFuture[]::new));
            }
            return CompletableFuture.completedFuture(null);
        }, (Executor)Util.m_183991_());
    }

    @NotNull
    protected CompletableFuture<List<ModelData>> runConvert(CachedOutput cachedOutput, ModelData base) {
        CompletionStage<Object> cf = CompletableFuture.completedFuture(ImmutableList.of((Object)base));
        for (ModelProcessSubProviderWrapper subProviderWrapper : this.subProviderWrappers) {
            cf = cf.thenApplyAsync(r -> subProviderWrapper.process(cachedOutput, (List<ModelData>)r), (Executor)Util.m_183991_());
        }
        return cf;
    }

    public record ModelData(ResourceLocation location, JsonObject model) {
        public String getName() {
            String[] sp = this.location.m_135815_().split("/");
            return sp[sp.length - 1];
        }
    }
}

