/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.shape;

import dev.architectury.registry.ReloadListenerRegistry;
import dev.felnull.otyacraftengine.client.shape.ClientIVShapeLoader;
import dev.felnull.otyacraftengine.client.shape.VoxelClientShape;
import dev.felnull.otyacraftengine.resources.PlatformResourceReloadListener;
import dev.felnull.otyacraftengine.shape.VoxelEdge;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientIVShapeManager
extends PlatformResourceReloadListener<ClientIVShapeLoader> {
    private static final ClientIVShapeManager INSTANCE = new ClientIVShapeManager();
    private static final ResourceLocation VOXEL_SHAPE = new ResourceLocation("otyacraftengine", "voxel_shape");
    private Map<ResourceLocation, VoxelClientShape> voxelClientShapes;
    private Map<ResourceLocation, VoxelClientShape> legacyVoxelClientShapes = new HashMap<ResourceLocation, VoxelClientShape>();

    public static ClientIVShapeManager getInstance() {
        return INSTANCE;
    }

    public void init() {
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)this);
    }

    protected ClientIVShapeLoader prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        return new ClientIVShapeLoader(resourceManager, profilerFiller);
    }

    protected void apply(@NotNull ClientIVShapeLoader loader, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        this.voxelClientShapes = loader.getVoxelClientShapes();
    }

    @Nullable
    public VoxelClientShape getVoxelClientShape(@Nullable ResourceLocation location) {
        VoxelClientShape ret = this.voxelClientShapes.get(location);
        if (ret != null) {
            return ret;
        }
        return this.legacyVoxelClientShapes.get(location);
    }

    public void addLegacyShapes(ResourceLocation location, Set<VoxelEdge> edges) {
        this.legacyVoxelClientShapes.put(location, new VoxelClientShape(null, null, edges));
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return VOXEL_SHAPE;
    }
}

